package cn.com.duiba.tuia.ssp.center.api.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.apache.commons.lang3.builder.ToStringBuilder;

import java.io.Serializable;
import java.util.List;

@ApiModel
public class SlotAndAppNameReq implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "广告位ID")
    private List<Long> slotIds;

    @ApiModelProperty(value = "媒体ID")
    private List<Long> appIds;

    @ApiModelProperty(value = "广告位名称")
    private String slotName;

    @ApiModelProperty(value = "媒体名称")
    private String appName;

    @ApiModelProperty(value = "平台类型")
    private String platform;

    @ApiModelProperty(value = "广告位类型,传入不会搜出该类型广告位")
    private String slotType;

    public List<Long> getSlotIds() {
        return slotIds;
    }

    public void setSlotIds(List<Long> slotIds) {
        this.slotIds = slotIds;
    }

    public List<Long> getAppIds() {
        return appIds;
    }

    public void setAppIds(List<Long> appIds) {
        this.appIds = appIds;
    }

    public String getSlotName() {
        return slotName;
    }

    public void setSlotName(String slotName) {
        this.slotName = slotName;
    }

    public String getAppName() {
        return appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public String getPlatform() {
        return platform;
    }

    public void setPlatform(String platform) {
        this.platform = platform;
    }

    public String getSlotType() {
        return slotType;
    }

    public void setSlotType(String slotType) {
        this.slotType = slotType;
    }

    @Override public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }
}
