package cn.com.duiba.tuia.ssp.center.api.remote;

import cn.com.duiba.tuia.ssp.center.api.dto.AccountCheckRecordDto;
import cn.com.duiba.tuia.ssp.center.api.dto.AccountDto;
import cn.com.duiba.tuia.ssp.center.api.dto.IdAndNameDto;
import cn.com.duiba.tuia.ssp.center.api.dto.ReqGetAccountByPageDto;
import cn.com.duiba.wolf.dubbo.DubboResult;
import java.util.List;

public interface RemoteAccountService {
    DubboResult<AccountDto> selectByAccount(String account);

    DubboResult<Integer> selectMediaDataAmount(ReqGetAccountByPageDto req);

    DubboResult<List<AccountDto>> selectMediaDataByPage(ReqGetAccountByPageDto req);

    DubboResult<Integer> insert(AccountDto accountDto);

    DubboResult<Integer> updateAuditData(AccountDto accountDto);

    DubboResult<AccountDto> selectByPhone(String phone);

    DubboResult<Integer> updateEmail(String email, Long mediaId);

    DubboResult<Integer> updatePasswdByEmail(String password, String email);

    DubboResult<Integer> updateEmailStatus(Integer status, Long mediaId);

    DubboResult<Integer> updateRoleType(Integer roleType, Long mediaId);

    DubboResult<Integer> updateAccount(String companyName, String linkman, Long mediaId);

    DubboResult<Integer> updatePhoneNum(String phoneNum, Long mediaId);

    DubboResult<List<IdAndNameDto>> selectMediaIdAndEmails(List<Long> mediaIds);

    DubboResult<Integer> selectFirstEnterStatus(Long mediaId);

    DubboResult<Integer> updateFirstEnterStatus(Long mediaId);

    DubboResult<AccountCheckRecordDto> selectLatelyCheckRecord(Long mediaId, Integer checkType);

    /**
     *  更新数量
     * @param mediaId    用户ID
     * @param isOffline 是否是线下打款媒体 0 普通媒体 1 线下打款媒体
     * @return
     */
    DubboResult<Integer> updateIsOffline(Long mediaId, Integer isOffline);
}
