/**
 * Project Name:media-manager-biz File Name:ReqSlotDayBillByPage.java Package
 * Name:cn.com.duiba.tuia.media.manager.model.req Date:2017年2月8日下午2:27:55 Copyright (c) 2017, duiba.com.cn All Rights
 * Reserved.
 */

package cn.com.duiba.tuia.ssp.center.api.dto;

import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.List;

import javax.validation.constraints.NotNull;

import org.apache.commons.lang.builder.ToStringBuilder;
import org.springframework.format.annotation.DateTimeFormat;

/**
 * ClassName:ReqSlotDayBillByPage <br/>
 * Function: 广告位日账单. <br/>
 * Date: 2017年2月8日 下午2:27:55 <br/>
 * 
 * @author guyan
 * @version
 * @since JDK 1.6
 * @see
 */
public class ReqSlotDayBillByPage extends ReqPageQuery implements Serializable {

    /** 序列号 */
    private static final long serialVersionUID = 3243212667778150152L;

    /** 广告位名称 */
    @ApiModelProperty(value = "广告位名称", required = false)
    private String            slotName;

    /** 广告位ID */
    @ApiModelProperty(value = "广告位ID", required = false)
    private Long              slotId;

    /** 媒体名称 */
    @ApiModelProperty(value = "媒体名称", required = false)
    private String            appName;

    /** 媒体ID */
    @ApiModelProperty(value = "媒体ID", required = false)
    private Long              appId;

    /** 开始日期 */
    @ApiModelProperty(value = "开始日期", required = true)
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @NotNull(message = "开始日期不能为空")
    private String            startDate;

    /** 结束日期 */
    @ApiModelProperty(value = "结束日期", required = true)
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @NotNull(message = "结束日期不能为空")
    private String            endDate;

    /** 媒体ids */
    @ApiModelProperty(value = "媒体ids", required = false)
    private List<Long>        appIds;

    /** 广告位Ids */
    @ApiModelProperty(value = "广告位Ids", required = false)
    private List<Long>        slotIds;

    @ApiModelProperty(value = "开发者ID",required = false)
    private Long             mediaId;

    @ApiModelProperty(value = "媒体账号",required = false)
    private String             email;

    /**
     * Gets the slotName.
     *
     * @return the slotName
     */
    public String getSlotName() {
        return slotName;
    }

    /**
     * Sets the slotName.
     *
     * @param slotName the slotName
     */
    public void setSlotName(String slotName) {
        this.slotName = slotName;
    }

    /**
     * Gets the slotId.
     *
     * @return the slotId
     */
    public Long getSlotId() {
        return slotId;
    }

    /**
     * Sets the slotId.
     *
     * @param slotId the slotId
     */
    public void setSlotId(Long slotId) {
        this.slotId = slotId;
    }

    /**
     * Gets the appName.
     *
     * @return the appName
     */
    public String getAppName() {
        return appName;
    }

    /**
     * Sets the appName.
     *
     * @param appName the appName
     */
    public void setAppName(String appName) {
        this.appName = appName;
    }

    /**
     * Gets the appId.
     *
     * @return the appId
     */
    public Long getAppId() {
        return appId;
    }

    /**
     * Sets the appId.
     *
     * @param appId the appId
     */
    public void setAppId(Long appId) {
        this.appId = appId;
    }

    /**
     * Gets the appIds.
     *
     * @return the appIds
     */
    public List<Long> getAppIds() {
        return appIds;
    }

    /**
     * Sets the appIds.
     *
     * @param appIds the appIds
     */
    public void setAppIds(List<Long> appIds) {
        this.appIds = appIds;
    }

    /**
     * Gets the startDate.
     *
     * @return the startDate
     */
    public String getStartDate() {
        return startDate;
    }

    /**
     * Sets the startDate.
     *
     * @param startDate the startDate
     */
    public void setStartDate(String startDate) {
        this.startDate = startDate;
    }

    /**
     * Gets the endDate.
     *
     * @return the endDate
     */
    public String getEndDate() {
        return endDate;
    }

    /**
     * Sets the endDate.
     *
     * @param endDate the endDate
     */
    public void setEndDate(String endDate) {
        this.endDate = endDate;
    }

    /**
     * Gets the slotIds.
     *
     * @return the slotIds
     */
    public List<Long> getSlotIds() {
        return slotIds;
    }

    /**
     * Sets the slotIds.
     *
     * @param slotIds the slotIds
     */
    public void setSlotIds(List<Long> slotIds) {
        this.slotIds = slotIds;
    }

    public Long getMediaId() {
        return mediaId;
    }

    public void setMediaId(Long mediaId) {
        this.mediaId = mediaId;
    }

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);

    }

}
