/**
 * Project Name:media-api File Name:RspMediaAppDto.java Package Name:cn.com.duiba.tuia.media.api.dto
 * Date:2016年10月8日下午5:15:30 Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 */

package cn.com.duiba.tuia.ssp.center.api.dto;

import java.io.Serializable;
import java.util.List;

import org.apache.commons.lang.builder.ToStringBuilder;

/**
 * ClassName:RspMediaAppDto <br/>
 * Function: 媒体配置信息dto. <br/>
 * Date: 2016年10月8日 下午5:15:30 <br/>
 * 
 * @author guyan
 * @version
 * @since JDK 1.6
 * @see
 */
public class RspMediaAppConfigDto implements Serializable {

    /** 序列号 */
    private static final long serialVersionUID = -4778018985291543266L;

    /** 媒体Id */
    private Long              appId;
    /** 媒体名称 */
    private String            appName;
    /** 媒体平台 */
    private String            platform;
    /** 邮箱账号 */
    private String            email;
    /** 开通状态. */
    private Integer           checkStatus;
    /** 创建日期 */
    private String            createDate;
    /** 用户ID */
    private Long              mediaId;
    /**管理人员id 集合(权限)*/
    private List<Long>        managerList;
    /**管理人员名称 集合(权限)*/
    private List<String>      managerNameList;
    /**媒体冻结原因*/
    private String  mediaFrozenReason;
    /**媒体冻结状态*/
    private Integer mediaFrozenStatus; 

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public String getAppName() {
        return appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public String getPlatform() {
        return platform;
    }

    public void setPlatform(String platform) {
        this.platform = platform;
    }

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public Integer getCheckStatus() {
        return checkStatus;
    }

    public void setCheckStatus(Integer checkStatus) {
        this.checkStatus = checkStatus;
    }

    public String getCreateDate() {
        return createDate;
    }

    public void setCreateDate(String createDate) {
        this.createDate = createDate;
    }

    public Long getMediaId() {
        return mediaId;
    }

    public void setMediaId(Long mediaId) {
        this.mediaId = mediaId;
    }

    public List<Long> getManagerList() {
        return managerList;
    }

    public void setManagerList(List<Long> managerList) {
        this.managerList = managerList;
    }

    public List<String> getManagerNameList() {
        return managerNameList;
    }

    public void setManagerNameList(List<String> managerNameList) {
        this.managerNameList = managerNameList;
    }
    
    public String getMediaFrozenReason() {
        return mediaFrozenReason;
    }

    
    public void setMediaFrozenReason(String mediaFrozenReason) {
        this.mediaFrozenReason = mediaFrozenReason;
    }

    
    public Integer getMediaFrozenStatus() {
        return mediaFrozenStatus;
    }

    
    public void setMediaFrozenStatus(Integer mediaFrozenStatus) {
        this.mediaFrozenStatus = mediaFrozenStatus;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

}
