package cn.com.duiba.tuia.ssp.center.api.remote;

import java.util.List;
import java.util.Map;

import cn.com.duiba.tuia.ssp.center.api.dto.ActivitySortDto;
import cn.com.duiba.tuia.ssp.center.api.dto.PageResultDto;
import cn.com.duiba.tuia.ssp.center.api.dto.ReqActivitySort;
import cn.com.duiba.tuia.ssp.center.api.dto.ReqIdAndType;
import cn.com.duiba.tuia.ssp.center.api.dto.RspActivityDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * @author xuyenan
 * @createTime 2016/10/25
 */
public interface RemoteActivitySortBackendService {

    /**
     * getByCondition:(查询活动列表接口). <br/>
     *
     * @author ZFZ
     * @param reqActivitySort
     * @return
     * @since JDK 1.6
     */
    DubboResult<PageResultDto<RspActivityDto>> getByCondition(ReqActivitySort reqActivitySort, Map<Integer,String> actTypeMap);
    
    //查询活动组活动列表
    DubboResult<PageResultDto<RspActivityDto>> ListActGroup(ReqActivitySort reqActivitySort, Map<Integer,String> actTypeMap);  //NOSONAR 接口暂不修改
    
    //管理活动组页面活动列表
    DubboResult<List<RspActivityDto>> ListActGroupById(Long groupId, Map<Integer,String> actTypeMap);   //NOSONAR 接口暂不修改


    /**
     * removeActivity:(移除活动接口). <br/>
     *
     * @author ZFZ
     * @param slotId 广告位ID
     * @param activityId 活动ID
     * @param activityType 活动类型
     * @return
     * @since JDK 1.6
     */
    DubboResult<Boolean> removeActivity(Long slotId, Long activityId, Integer activityType);
    
    /**
     * removeActivity:(移除活动接口). <br/>
     *
     * @author ZFZ
     * @param slotId 广告位ID
     * @param activityId 活动ID
     * @param source 活动来源
     * @return
     * @since JDK 1.6
     */
    DubboResult<Boolean> removeActivityBySource(Long slotId, Long activityId, Integer source);
    
    //移除活动组
    DubboResult<Boolean> deleteActivityGroup(Long actGroupId, Long slotId);

    /**
     * sort:(排序接口). <br/>
     *
     * @author ZFZ
     * @param slotId 广告位ID
     * @param activityId 活动ID
     * @param activityType 位置
     * @param location
     * @return
     * @since JDK 1.6
     */
    DubboResult<Boolean> sort(Long slotId, Long activityId, Integer activityType, int location);
    
    /**
     * sort:(排序接口). <br/>
     *
     * @author ZFZ
     * @param slotId 广告位ID
     * @param activityId 活动ID
     * @param source 
     * @param location 位置
     * @return
     * @since JDK 1.6
     */
    DubboResult<Boolean> sortBySource(Long slotId, Long activityId, Integer source, int location);
    
    /**
     * 活动组排序
     * @param slotId
     * @param activityId
     * @param source
     * @param location 位置
     * @return
     */
    DubboResult<Boolean> sortActGroup(Long slotId, Long actGroupId, int location);

    /**
     * 给活动中心的提供的接口,获取推荐的活动ID列表
     * 
     * @param slotId 数量
     * @return
     */
    DubboResult<List<Long>> getActivityIdForCenter(Long slotId);
    
    /**
     * 获取默认列表
     * 
     * @return 活动列表
     */
    DubboResult<List<RspActivityDto>> getDefaultActivityList();

    /**
     * addActivitySort:(添加活动接口). <br/>
     *
     * @author ZFZ
     * @param slotId 广告位ID
     * @param idAndTypes 活动列表
     * @return
     * @since JDK 1.6
     */
    DubboResult<Boolean> addActivitySort(Long slotId, List<ReqIdAndType> idAndTypes,Map<Integer,String> actTypeMap);
    
    /**
     * 添加活动组接口
     * @param slotId
     * @param idAndTypes
     * @param actTypeMap
     * @return
     */
    DubboResult<Boolean> addActivityGroupSort(Long slotId, List<ReqIdAndType> idAndTypes,Map<Integer,String> actTypeMap);

    /**
     * addDefaultActivitySort:(添加默认活动接口). <br/>
     *
     * @author ZFZ
     * @param slotId
     * @return
     * @since JDK 1.6
     */
    DubboResult<Boolean> addDefaultActivitySort(Long slotId,Map<Integer,String> actTypeMap);
    
    /**
     * 
     * getAllActivityBySlotId:(查询该广告位下面所有的活动). <br/>
     *
     * @author guyan
     * @param slotId
     * @return
     * @since JDK 1.6
     */
    DubboResult<List<ActivitySortDto>> getAllActivityBySlotId(Long slotId);

    DubboResult<List<ActivitySortDto>> selectBySlot(Long slotId);
}
