/**
 * Project Name:tuia-ssp-center<br>
 * File Name:<br>
 * Package Name:cn.com.duiba.tuia.ssp.center.api.remote<br>
 * Date:2017年06月08日下午2:53<br>
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.<br>
 */
package cn.com.duiba.tuia.ssp.center.api.remote;

import java.util.Date;
import java.util.List;

import cn.com.duiba.tuia.ssp.center.api.dto.BuoyDataDto;
import cn.com.duiba.tuia.ssp.center.api.dto.BuoySumReqDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * ClassName: RemoteBuoyDataService <br/>
 * Function:  浮标数据service<br/>
 * Date: 2017年06月08日 下午2:53 <br/>
 *
 * @author Dozening
 * @see
 * @since JDK 1.6
 */
public interface RemoteBuoyDataService {
	
	//广告位维度--获取浮标分日数据
	DubboResult<List<BuoyDataDto>> listDayBySlotIds(Date start, Date end, List<Long> ids);
	
	//媒体维度--获取浮标分日数据
	DubboResult<List<BuoyDataDto>> listDayByAppIds(Date start, Date end, List<Long> ids);
	
	//活动维度--获取浮标分日数据
	DubboResult<List<BuoyDataDto>> listDayByActIds(Date start, Date end, List<Long> ids);
	
	//广告位活动维度--获取浮标分日数据
	DubboResult<List<BuoyDataDto>> listDayBySlotAct(Date startTime,Date endTime,Long slotId,List<Long> activityIds);
	
	//活动广告位维度--获取浮标分日数据
	DubboResult<List<BuoyDataDto>> listDayByActSlot(Date startTime,Date endTime,Long activityId,List<Long> slotIds);
	
	//活动媒体维度--获取浮标分日数据
	DubboResult<List<BuoyDataDto>> listDayByActApp(Date startTime,Date endTime,Long activityId,List<Long> appIds);
	
	
	/** 浮标求和数据 **/
	DubboResult<BuoyDataDto> selectSumData(BuoySumReqDto req);

    /**
     *
     * @param start 开始时间
     * @param end 结束时间
     * @param slotIds 广告位Id
     * @return
     */
    DubboResult<List<BuoyDataDto>> selectBuoyBySlotIds(Date start, Date end, List<Long> slotIds);
    
    DubboResult<BuoyDataDto> selectSumBuoy(Date start, Date end, List<Long> slotIds);

    /**
     *
     * @param start
     * @param end
     * @param activityIds
     * @return
     */
    DubboResult<List<BuoyDataDto>> selectBuoyByActivityIds(Date start, Date end, List<Long> activityIds);
    //求和数据
    DubboResult<BuoyDataDto> selectSumBuoyByActivityIds(Date start, Date end, List<Long> activityIds);
    
    /**
     * 
     * selectBuoyDataList:(查询app浮标数据). <br/>
     *
     * @author guyan
     * @param start
     * @param end
     * @param appIds
     * @return
     * @since JDK 1.6
     */
    DubboResult<List<BuoyDataDto>> selectAppBuoyDataList(Date start, Date end, List<Long> appIds);
    //求和数据
    DubboResult<BuoyDataDto> selectAppBuoySumData(Date start, Date end, List<Long> appIds);
    
    /**
     * 
     * selectAppSlotBouyList:(查询app广告浮标数据列表). <br/>
     *
     * @author guyan
     * @param startTime
     * @param endTime
     * @param appId
     * @return
     * @since JDK 1.6
     */
    DubboResult<List<BuoyDataDto>> selectAppSlotBouyList(Date startTime, Date endTime, Long appId);

    /**
     *
     * @param start
     * @param end
     * @param activityId
     * @param slotIds
     * @return
     */
    DubboResult<List<BuoyDataDto>> selectBuoyByActivityIdAndSlotIds(Date start, Date end, Long activityId, List<Long> slotIds);

    /**
     *
     * @param start
     * @param end
     * @param activityId
     * @param appId
     * @param slotIds
     * @return
     */
    DubboResult<List<BuoyDataDto>> selectBuoyByActivityIdAndAppIdAndSlotIds(Date start, Date end, Long activityId, Long appId, List<Long> slotIds);

//每日数据
    /**
     *
     * @param start
     * @param end
     * @param slotId
     * @return
     */
    DubboResult<List<BuoyDataDto>> selectDailyBuoyBySlotId(Date start, Date end, Long slotId);

    /**
     *
     * @param start
     * @param end
     * @param activityId
     * @param slotId
     * @return
     */
    DubboResult<List<BuoyDataDto>> selectBuoyDailyByActivityIdAndSlotId(Date start, Date end, Long activityId, Long slotId);
    
    /**
     * 
     * selectAppBuoyDailyList:(查询媒体浮标每日数据). <br/>
     *
     * @author guyan
     * @param start
     * @param end
     * @param appId
     * @return
     * @since JDK 1.6
     */
    DubboResult<List<BuoyDataDto>> selectAppBuoyDailyList(Date start, Date end, Long appId);
    
    /**
     * 
     * selectAppSlotBouyDailyList:(查询媒体应用下广告的每日浮标数据). <br/>
     *
     * @author guyan
     * @param startTime
     * @param endTime
     * @param appId
     * @return
     * @since JDK 1.6
     */
    DubboResult<List<BuoyDataDto>> selectAppSlotBouyDailyList(Date startTime, Date endTime, Long appId);
    
    /**
     * 
     * selectActAppBouyDailyList:(查询活动对应的媒体浮标每日数据). <br/>
     *
     * @author guyan
     * @param startTime
     * @param endTime
     * @param activityId
     * @param appId
     * @return
     * @since JDK 1.6
     */
    DubboResult<List<BuoyDataDto>> selectActAppBouyDailyList(Date startTime, Date endTime, Long activityId, Long appId);
    
    /**
     * 
     * selectActAppBouyList:(查询活动对应的媒体浮标数据). <br/>
     *
     * @author guyan
     * @param startTime
     * @param endTime
     * @param activityId
     * @return
     * @since JDK 1.6
     */
    DubboResult<List<BuoyDataDto>> selectActAppBouyList(Date startTime, Date endTime, Long activityId);

    /**
     * 查询某广告位下 活动维度的数据 <br/>
     *
     * where slot_id = ? and activity_id in (?) and cur_date between group by activity_id
     * @param startTime 开始时间
     * @param endTime 结束时间
     * @param slotId 广告位id
     * @param activityIds 活动id
     * @return List<BuoyDataDto>
     */
    DubboResult<List<BuoyDataDto>> selectSlotBuoyByActivityIds(Date startTime, Date endTime,Long slotId,List<Long> activityIds);
    
    /**
     * 
     * selectDailyBuoyByActivityIds:(查询浮标每日数据通过活动ids). <br/>
     *
     * @author guyan
     * @param startTime
     * @param endTime
     * @param activityIds
     * @return
     * @since JDK 1.6
     */
    DubboResult<List<BuoyDataDto>> selectBuoyDailyByActivityIds(Date startTime,Date endTime,List<Long> activityIds);
}
