package cn.com.duiba.tuia.ssp.center.api.remote;


import cn.com.duiba.tuia.ssp.center.api.dto.IdAndNameDto;
import cn.com.duiba.tuia.ssp.center.api.dto.MediaAppDto;
import cn.com.duiba.tuia.ssp.center.api.dto.ReqPageQueryMediaApp;
import cn.com.duiba.tuia.ssp.center.api.dto.ReqUpdateMediaApp;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.List;

public interface RemoteMediaAppService {

    DubboResult<List<MediaAppDto>> selectByMediaId(Long mediaId);
    
    /**
     * 查询app
     *
     * @param appIds
     * @return
     * @since JDK 1.6
     */
    DubboResult<List<MediaAppDto>>selectByAppIds(List<Long> appIds);

    DubboResult<MediaAppDto> getMediaAppByName(String appName);

    DubboResult<Integer> insert(MediaAppDto mediaAppDto);

    DubboResult<Integer> selectAmountByPageQuery(ReqPageQueryMediaApp reqPageQueryMediaApp);

    DubboResult<List<MediaAppDto>> selectMediaAppList(ReqPageQueryMediaApp reqPageQueryMediaApp);

    DubboResult<Integer> update(ReqUpdateMediaApp reqUpdateMediaApp);

    DubboResult<List<IdAndNameDto>> selectAppIdAndNameByMediaId(Long mediaId);

    DubboResult<List<IdAndNameDto>> selectAppIdAndName(List<Long> appIds);

    /**
     * getMediaApp:(查看媒体应用信息状态). <br/>
     *
     * @author ZFZ
     * @param appId
     * @return
     * @since JDK 1.6
     */
    DubboResult<MediaAppDto> getMediaApp(Long appId);
    
    /**
	 * 通过mediaIds 查询MediaAppDto 列表
	 * @param mediaIds
	 * @return
	 */
    DubboResult<List<MediaAppDto>> selectAppByMediaIds(List<Long> mediaIds);

    DubboResult<List<IdAndNameDto>> getAppIdAndName(List<Long> appIds);

    DubboResult<Boolean> updateMediaAppCache(Long appId);

    DubboResult<Boolean> updateAppIdAndName(Long appId, String appName);
}
