/**
 * Project Name:media-api<br>
 * File Name:MediaService.java<br>
 * Package Name:cn.com.duiba.tuia.media.api.service<br>
 * Date:2016年9月29日下午2:12:54<br>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.<br>
 */

package cn.com.duiba.tuia.ssp.center.api.remote;

import cn.com.duiba.tuia.ssp.center.api.dto.MediaAppDataDto;
import cn.com.duiba.tuia.ssp.center.api.dto.SlotCacheDto;
import cn.com.duiba.tuia.ssp.center.api.dto.SlotCfgCacheDto;
import cn.com.duiba.tuia.ssp.center.api.dto.StrategyCacheDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * ClassName: RemoteMediaService <br/>
 * Function: 推啊媒体服务. <br/>
 * date: 2016年9月29日 下午2:12:54 <br/>
 *
 * @author leiliang
 * @version
 * @since JDK 1.6
 */
public interface RemoteMediaService {

    /**
     * 查询屏蔽策略信息.<br>
     * [使用说明]
     * <ol>
     * <li>当发生数据库失败时：returnCode=0002001</li>
     * <li>当该广告位不存在时：returnCode=0304008</li>
     * <li>当发生其他错误时：returnCode=9999999</li>
     * </ol>
     *
     * @param slotId the slot id
     * @return the strategy
     */
    DubboResult<StrategyCacheDto> getStrategy(Long slotId);

    /**
     * 查询媒体APP是否有效.<br>
     * [使用说明]<br>
     * true:有效<br>
     * false:无效<br>
     *
     * @param mediaAppId 媒体APPid
     * @return the dubbo result< boolean>
     */
    DubboResult<Boolean> isValidMediaApp(Long mediaAppId);

    /**
     * 查询媒体信息.<br>
     * [使用说明]
     * <ol>
     * <li>当发生数据库失败时：returnCode=0002001</li>
     * <li>当该媒体不存在时：returnCode=0401001</li>
     * <li>当发生其他错误时：returnCode=9999999</li>
     * </ol>
     * 
     * @param mediaAppId 媒体ID
     * @return the media app
     */
    DubboResult<MediaAppDataDto> getMediaApp(Long mediaAppId);

    /**
     * 查询媒体信息.<br>
     * [使用说明]
     * <ol>
     * <li>当发生数据库失败时：returnCode=0002001</li>
     * <li>当该媒体不存在时：returnCode=0401001</li>
     * <li>当发生其他错误时：returnCode=9999999</li>
     * </ol>
     *
     * @param appKey the app key
     * @return the media app
     */
    DubboResult<MediaAppDataDto> getMediaAppByKey(String appKey);

    /**
     * 更新媒体缓存信息.
     *
     * @param appKey the app key
     * @return the dubbo result< media app data dto>
     */
    DubboResult<MediaAppDataDto> updateMediaAppByKey(String appKey);

    /**
     * 查询广告位信息.<br>
     * [使用说明]
     * <ol>
     * <li>当发生数据库失败时：returnCode=0002001</li>
     * <li>当该广告位不存在时：returnCode=0304008</li>
     * <li>当发生其他错误时：returnCode=9999999</li>
     * </ol>
     *
     * @param slotId the slot id
     * @return the dubbo result< boolean>
     */
    DubboResult<SlotCacheDto> getSlot(Long slotId);

    /**
     * 查询广告位配置信息.<br>
     * [提供给tuia-activity-web使用，查询广告位返回拦截和浮标配置]
     * <ol>
     * <li>当发生数据库失败时：returnCode=0002001</li>
     * <li>当该广告位不存在或不可用时时：returnCode=0304008</li>
     * <li>当发生其他错误时：returnCode=9999999</li>
     * </ol>
     *
     * @param slotId the slot id
     * @return the dubbo result< boolean>
     */
    DubboResult<SlotCfgCacheDto> getSlotCfg(long slotId);

    /**
     * Update slot.
     *
     * @param slotId the slot id
     * @return the dubbo result< slot cache dto>
     */
    DubboResult<SlotCacheDto> updateSlot(Long slotId);

    /**
     * 更新广告位的屏蔽策略缓存.<br>
     * [使用说明]
     * <ol>
     * <li>当发生数据库失败时：returnCode=0002001</li>
     * <li>当该广告位不存在时：returnCode=0304008</li>
     * <li>当发生其他错误时：returnCode=9999999</li>
     * </ol>
     *
     * @param slotId 广告位id
     * @return the dubbo result< strategy dto>
     */
    DubboResult<StrategyCacheDto> updateStrategy(Long slotId);

    /**
     * 更新屏蔽策略缓存.
     *
     * @param strategyId the strategy id
     * @return the dubbo result< strategy cache dto>
     */
    DubboResult<StrategyCacheDto> updateStrategyById(Long strategyId);
}
