/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.ssp.center.api.annotation;

import cn.com.duiba.tuia.ssp.center.api.annotation.SensitiveInfo;
import cn.com.duiba.tuia.ssp.center.api.annotation.SensitiveType;
import java.lang.reflect.Field;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class SensitiveUtil {
    private SensitiveUtil() {
    }

    public static <T> void sensitive(T o) {
        try {
            if (o == null) {
                return;
            }
            Field[] fileds = SensitiveUtil.findAllField(o.getClass());
            if (fileds.length == 0) {
                return;
            }
            for (Field field : fileds) {
                if (!field.isAnnotationPresent(SensitiveInfo.class) || field.getType() != String.class) continue;
                field.setAccessible(true);
                SensitiveInfo sensitiveInfo = field.getAnnotation(SensitiveInfo.class);
                String value = (String)field.get(o);
                SensitiveType type = sensitiveInfo.sensitiveType();
                field.set(o, SensitiveUtil.sensitiveStr(value, type));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static <T> void sensitive(List<T> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.forEach(o -> SensitiveUtil.sensitive(o));
    }

    private static Field[] findAllField(Class<?> clazz) throws NoSuchFieldException {
        Field[] fileds = new Field[]{};
        SensitiveInfo sensitiveInfo = clazz.getAnnotation(SensitiveInfo.class);
        if (null != sensitiveInfo && sensitiveInfo.sensitiveFields() != null) {
            String[] fieldNames = sensitiveInfo.sensitiveFields();
            for (int i = 0; i < fieldNames.length; ++i) {
                fileds[i] = clazz.getDeclaredField(fieldNames[i]);
            }
        }
        return fileds;
    }

    public static String sensitiveStr(String concent, SensitiveType type) {
        switch (type) {
            case USERNAME: {
                return SensitiveUtil.sensitive4uname(concent);
            }
            case EMAIL: {
                return SensitiveUtil.sensitive4email(concent);
            }
            case MOBILE: {
                return SensitiveUtil.sensitive4mobile(concent);
            }
        }
        return "";
    }

    private static String sensitive4uname(String concent) {
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{concent})) {
            String first = StringUtils.left((String)concent, (int)1);
            return StringUtils.replace((String)concent, (String)first, (String)"*", (int)1);
        }
        return "";
    }

    private static String sensitive4mobile(String concent) {
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{concent})) {
            String head = StringUtils.left((String)concent, (int)3);
            String foot = StringUtils.right((String)concent, (int)4);
            return head + "****" + foot;
        }
        return "";
    }

    private static String sensitive4email(String concent) {
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{concent})) {
            String head = StringUtils.substring((String)concent, (int)0, (int)StringUtils.indexOf((CharSequence)concent, (CharSequence)"@"));
            return StringUtils.replace((String)concent, (String)head, (String)"****", (int)1);
        }
        return "";
    }
}

