/**
 * 文件名： AdvertiserDO.java 此类描述的是： 作者: leiliang 创建时间: 2016年4月1日 下午1:36:56
 */
package cn.com.duiba.tuia.ssp.center.api.dto;

import org.apache.commons.lang.builder.ToStringBuilder;

/**
 * @author: leiliang
 * @version:
 */
public class AccountDto extends BaseDto {

    private static final long   serialVersionUID     = 4476874317666316204L;
    /** 角色类型：公司 */
    public static final Integer ROLE_TYPE_COMPANY    = 0;
    /** 角色类型：个人 */
    public static final Integer ROLE_TYPE_PERSONAL   = 1;
    /** 角色类型： 默认 */
    public static final Integer ROLE_TYPE_DEFAULT    = 99;

    /** 修改状态：true */
    public static final boolean EDITED_TRUE          = true;
    /** 修改状态：false */
    public static final boolean EDITED_FALSE         = false;

    /** 邮箱未验证. */
    public static final int     EMAIL_STATUS_UNCHECK = 0;

    /** 邮箱已验证. */
    public static final int     EMAIL_STATUS_CHECKED = 1;

    /** 未冻结. */
    public static final int     UNFREEZED_STATUS     = 0;

    /** 已冻结. */
    public static final int     FREEZED_STATUS       = 1;

    /** 审核中. */
    public static final int     CHECK_STATUS_ING     = 0;

    /** 审核通过. */
    public static final int     CHECK_STATUS_PASS    = 1;

    /** 审核拒绝. */
    public static final int     CHECK_STATUS_REFUSE  = 2;
    
    /**用户类别未选*/
    public static final int     NO_ACCOUNT_TYPE=0;
    
    /**用户类别 直客*/
    public static final int     STRAIGHT_ACCOUNT_TYPE=1;
    
    /**用户类别 代理*/
    public static final int     AGENT_ACCOUNT_TYPE=2;
    
    /**已解锁*/
    public static final int     IS_UNLOCK_STATUS=1;
    
    /**未解锁*/
    public static final int     NO_UNLOCK_STATUS=0;
    
    /**允许数据访问*/
    public static final int    IS_ACCESS_DATA_STATUS=1;
    
    /**不允许数据访问*/
    public static final int    NO_ACCESS_DATA_STATUS=0;
    
    

    /** 媒体用户ID. */
    private Long                mediaId;

    /** 邮箱. */
    private String              email;

    /** 密码. */
    private String              password;

    /** 公司名称. */
    private String              companyName;

    /** 邮箱状态:0：未验证;1：已验证. */
    private Integer             emailStatus;

    /** 审核状态:0：审核中;1：审核通过;2：审核拒绝. */
    private Integer             checkStatus;

    /** 冻结状态:0：未冻结;1：冻结. */
    private Integer             freezeStatus;

    /** 营业执照号. */
    private String              businessLicenseId;

    /** 营业执照名称. */
    private String              businessLicenseName;

    /** 营业执照照片. */
    private String              businessLicenseUrl;

    /** 联系人姓名. */
    private String              linkman;

    /** 联系人手机号. */
    private String              linkPhone;

    /** 角色类型 :0-公司;1-个人. */
    private Integer             roleType;

    /** 账户类型：0-普通账户 1-线下打款账户 */
    private Integer             isOffline;
    
    /**解锁状态：0-未解锁 1-已解锁*/
    private Integer             unlockStatus;
    
    /**用户类别*/
    private Integer            accountType;
    
    /**允许访问数据状态：0:关闭，1:开启  */
    private Integer             accessDataStatus;

    

    /**
     * mediaId.
     *
     * @return the mediaId
     * @since JDK 1.6
     */
    public Long getMediaId() {
        return mediaId;
    }

    /**
     * mediaId.
     *
     * @param mediaId the mediaId to set
     * @since JDK 1.6
     */
    public void setMediaId(Long mediaId) {
        this.mediaId = mediaId;
    }

    /**
     * email.
     *
     * @return the email
     * @since JDK 1.6
     */
    public String getEmail() {
        return email;
    }

    /**
     * email.
     *
     * @param email the email to set
     * @since JDK 1.6
     */
    public void setEmail(String email) {
        this.email = email;
    }

    /**
     * companyName.
     *
     * @return the companyName
     * @since JDK 1.6
     */
    public String getCompanyName() {
        return companyName;
    }

    /**
     * companyName.
     *
     * @param companyName the companyName to set
     * @since JDK 1.6
     */
    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    /**
     * emailStatus.
     *
     * @return the emailStatus
     * @since JDK 1.6
     */
    public Integer getEmailStatus() {
        return emailStatus;
    }

    /**
     * emailStatus.
     *
     * @param emailStatus the emailStatus to set
     * @since JDK 1.6
     */
    public void setEmailStatus(Integer emailStatus) {
        this.emailStatus = emailStatus;
    }

    /**
     * checkStatus.
     *
     * @return the checkStatus
     * @since JDK 1.6
     */
    public Integer getCheckStatus() {
        return checkStatus;
    }

    /**
     * checkStatus.
     *
     * @param checkStatus the checkStatus to set
     * @since JDK 1.6
     */
    public void setCheckStatus(Integer checkStatus) {
        this.checkStatus = checkStatus;
    }

    /**
     * freezeStatus.
     *
     * @return the freezeStatus
     * @since JDK 1.6
     */
    public Integer getFreezeStatus() {
        return freezeStatus;
    }

    /**
     * freezeStatus.
     *
     * @param freezeStatus the freezeStatus to set
     * @since JDK 1.6
     */
    public void setFreezeStatus(Integer freezeStatus) {
        this.freezeStatus = freezeStatus;
    }

    /**
     * businessLicenseId.
     *
     * @return the businessLicenseId
     * @since JDK 1.6
     */
    public String getBusinessLicenseId() {
        return businessLicenseId;
    }

    /**
     * businessLicenseId.
     *
     * @param businessLicenseId the businessLicenseId to set
     * @since JDK 1.6
     */
    public void setBusinessLicenseId(String businessLicenseId) {
        this.businessLicenseId = businessLicenseId;
    }

    /**
     * businessLicenseName.
     *
     * @return the businessLicenseName
     * @since JDK 1.6
     */
    public String getBusinessLicenseName() {
        return businessLicenseName;
    }

    /**
     * businessLicenseName.
     *
     * @param businessLicenseName the businessLicenseName to set
     * @since JDK 1.6
     */
    public void setBusinessLicenseName(String businessLicenseName) {
        this.businessLicenseName = businessLicenseName;
    }

    /**
     * businessLicenseUrl.
     *
     * @return the businessLicenseUrl
     * @since JDK 1.6
     */
    public String getBusinessLicenseUrl() {
        return businessLicenseUrl;
    }

    /**
     * businessLicenseUrl.
     *
     * @param businessLicenseUrl the businessLicenseUrl to set
     * @since JDK 1.6
     */
    public void setBusinessLicenseUrl(String businessLicenseUrl) {
        this.businessLicenseUrl = businessLicenseUrl;
    }

    /**
     * linkman.
     *
     * @return the linkman
     * @since JDK 1.6
     */
    public String getLinkman() {
        return linkman;
    }

    /**
     * linkman.
     *
     * @param linkman the linkman to set
     * @since JDK 1.6
     */
    public void setLinkman(String linkman) {
        this.linkman = linkman;
    }

    /**
     * password.
     *
     * @return the password
     * @since JDK 1.6
     */
    public String getPassword() {
        return password;
    }

    /**
     * password.
     *
     * @param password the password to set
     * @since JDK 1.6
     */
    public void setPassword(String password) {
        this.password = password;
    }

    /**
     * linkPhone.
     *
     * @return the linkPhone
     * @since JDK 1.6
     */
    public String getLinkPhone() {
        return linkPhone;
    }

    /**
     * linkPhone.
     *
     * @param linkPhone the linkPhone to set
     * @since JDK 1.6
     */
    public void setLinkPhone(String linkPhone) {
        this.linkPhone = linkPhone;
    }

    /**
     * roleType.
     *
     * @return the roleType
     * @since JDK 1.6
     */
    public Integer getRoleType() {
        return roleType;
    }

    /**
     * roleType.
     *
     * @param roleType the roleType to set
     * @since JDK 1.6
     */
    public void setRoleType(Integer roleType) {
        this.roleType = roleType;
    }
    
    /**
     * isOffline.
     *
     * @return the isOffline
     * @since JDK 1.6
     */
    public Integer getIsOffline() {
        return isOffline;
    }
    
    /**
     * isOffline.
     *
     * @param isOffline the isOffline to set
     * @since JDK 1.6
     */
    public void setIsOffline(Integer isOffline) {
        this.isOffline = isOffline;
    }
    
    /**
     * unlockStatus.
     *
     * @return the unlockStatus
     * @since JDK 1.6
     */
    public Integer getUnlockStatus() {
        return unlockStatus;
    }

    /**
     * unlockStatus.
     *
     * @param unlockStatus the unlockStatus to set
     * @since JDK 1.6
     */
    public void setUnlockStatus(Integer unlockStatus) {
        this.unlockStatus = unlockStatus;
    }
    
    /**
     * accountType.
     *
     * @return the accountType
     * @since JDK 1.6
     */
    public Integer getAccountType() {
        return accountType;
    }

    /**
     * accountType.
     *
     * @param accountType the accountType to set
     * @since JDK 1.6
     */
    public void setAccountType(Integer accountType) {
        this.accountType = accountType;
    }
    
    /**
     * accessDataStatus.
     *
     * @return the accessDataStatus
     */
    public Integer getAccessDataStatus() {
        return accessDataStatus;
    }

    /**
     * accessDataStatus.
     *
     * @param accessDataStatus the accessDataStatus to set
     */
    public void setAccessDataStatus(Integer accessDataStatus) {
        this.accessDataStatus = accessDataStatus;
    }


    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

}
