/**
 * Project Name:ssp-center-api File Name:RspMediaCashRequirement.java Package Name:cn.com.duiba.tuia.ssp.center.api.dto
 * Date:2017年10月26日下午8:41:01 Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 */

package cn.com.duiba.tuia.ssp.center.api.dto;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;

import org.apache.commons.lang.builder.ToStringBuilder;

/**
 * ClassName:RspMediaCashRequirement <br/>
 * Function: 媒体请款单信息. <br/>
 * Date: 2017年10月26日 下午8:41:01 <br/>
 * 
 * @author guyan
 * @version
 * @see
 */
public class RspMediaCashRequirementDetails implements Serializable {

    /** 序列号 */
    private static final long serialVersionUID = -287413082975542686L;

    /** 账号id */
    private Long              mediaId;

    /** 收款单位 */
    private String            cashUnitName;

    /** 账号 */
    private String            cardNumber;

    /** 开户银行 */
    private String            bankName;

    /** 结算月份 */
    private Collection<String>    settledDate;

    /** 提现金额 */
    private Long              cashAmount;

    /** 媒体运营详情 */
    private String            mediaOperationsMsg;

    /** 风控运营详情 */
    private String            riskControlOperationsMsg;

    /** 媒介详情 */
    private String            mediumMsg;
    
    public List<String> getManagerNameList() {
        return managerNameList;
    }

    
    public void setManagerNameList(List<String> managerNameList) {
        this.managerNameList = managerNameList;
    }



    /**管理人员id 集合(权限)*/
    private List<Long>        managerList;
    /**管理人员名称 集合(权限)*/
    private List<String>      managerNameList;

    public String getCashUnitName() {
        return cashUnitName;
    }

    public void setCashUnitName(String cashUnitName) {
        this.cashUnitName = cashUnitName;
    }

    public Long getMediaId() {
        return mediaId;
    }

    public void setMediaId(Long mediaId) {
        this.mediaId = mediaId;
    }

    public String getCardNumber() {
        return cardNumber;
    }

    public void setCardNumber(String cardNumber) {
        this.cardNumber = cardNumber;
    }

    public String getBankName() {
        return bankName;
    }

    public void setBankName(String bankName) {
        this.bankName = bankName;
    }


    public Long getCashAmount() {
        return cashAmount;
    }

    public void setCashAmount(Long cashAmount) {
        this.cashAmount = cashAmount;
    }

    public String getMediaOperationsMsg() {
        return mediaOperationsMsg;
    }

    public void setMediaOperationsMsg(String mediaOperationsMsg) {
        this.mediaOperationsMsg = mediaOperationsMsg;
    }

    public String getRiskControlOperationsMsg() {
        return riskControlOperationsMsg;
    }

    public void setRiskControlOperationsMsg(String riskControlOperationsMsg) {
        this.riskControlOperationsMsg = riskControlOperationsMsg;
    }

    public String getMediumMsg() {
        return mediumMsg;
    }

    public void setMediumMsg(String mediumMsg) {
        this.mediumMsg = mediumMsg;
    }
    
    public Collection<String> getSettledDate() {
        return settledDate;
    }

    
    public void setSettledDate(Collection<String> settledDate) {
        this.settledDate = settledDate;
    }
    
    public List<Long> getManagerList() {
        return managerList;
    }

    
    public void setManagerList(List<Long> managerList) {
        this.managerList = managerList;
    }
    

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }
}
