/**
 * Project Name:ssp-center-api
 * File Name:RemoteAccountChangeService.java
 * Package Name:cn.com.duiba.tuia.ssp.center.api.remote
 * Date:2017年5月22日下午8:53:34
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.tuia.ssp.center.api.remote;

import cn.com.duiba.tuia.ssp.center.api.dto.ReqAccountChange;
import java.util.List;

import cn.com.duiba.tuia.ssp.center.api.dto.AccountChangeDto;
import cn.com.duiba.wolf.dubbo.DubboResult;


/**
 * ClassName:RemoteAccountChangeService <br/>
 * Function: 账户信息. <br/>
 * Date:     2017年5月22日 下午8:53:34 <br/>
 * @author   guyan
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
public interface RemoteAccountChangeService {
    
    /**
     * 通过月账单id查询提现信息
     * 
     * @param cashId
     * @return
     * @since JDK 1.6
     */
    DubboResult<AccountChangeDto> getAccountChangeByCashId(Long cashId);
    
    /**
     * 通过账户Id查询账户表里面已经提现的信息
     *
     * @param mediaId
     * @return
     * @since JDK 1.6
     */
    DubboResult<List<AccountChangeDto>> getAccountChangeListById(Long mediaId);

    /**
     * 查询媒体对应的余额
     * @param mediaId
     * @return
     */
    DubboResult<Long> getAccountBalance(Long mediaId);


    DubboResult<Integer> selectAccountChangeCount(ReqAccountChange req);

    DubboResult<List<AccountChangeDto>> getAccountChangeByPage(ReqAccountChange req);

    DubboResult<List<AccountChangeDto>> selectAccountChangeListByIds(List<Long> ids);

    DubboResult<AccountChangeDto> getAccountChangeById(Long id);

    DubboResult<AccountChangeDto> getAccountChangeByMediaId(Long mediaId);

    DubboResult<List<AccountChangeDto>> getAccountChangeList(ReqAccountChange req);
    
    /**
     * 
     * getAccountChangeListByCashId:(通过提现单ids查询用户提现信息). <br/>
     * 
     * @author guyan
     * @param cashIds
     * @return
     */
    DubboResult<List<AccountChangeDto>> getAccountChangeListByCashIds(List<Long> cashIds);
}

