/**
 * Project Name:ssp-center-api
 * File Name:RemoteMediaCashRequirement.java
 * Package Name:cn.com.duiba.tuia.ssp.center.api.remote
 * Date:2017年10月26日下午4:02:22
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.tuia.ssp.center.api.remote;

import java.util.List;

import cn.com.duiba.tuia.ssp.center.api.dto.MediaCashRequirementDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * ClassName:RemoteMediaCashRequirementService <br/>
 * Function: 媒体请款单. <br/>
 * Date:     2017年10月26日 下午4:02:22 <br/>
 * @author   guyan
 * @version  
 * @see 	 
 */
public interface RemoteMediaCashRequirementService {
    
    
    /**
     * 
     * selectCashRequirmentList:(查询请款单信息). <br/>
     *
     * @author guyan
     * @return
     */
    public DubboResult<List<MediaCashRequirementDto>> selectCashRequirmentList(List<Long> cashOrderIds);
    
    /**
     * 
     * updatePrintNum:(更新请款单打印次数). <br/>
     *
     * @author guyan
     * @param cashOrderIds
     * @return
     */
    public DubboResult<Boolean> updatePrintNum(List<Long> cashOrderIds);
    
    /**
     * 
     * updatePrintStatus:(更新打印状态). <br/>
     *
     * @author guyan
     * @param cashOrderIds
     * @return
     */
    public DubboResult<Boolean> updatePrintStatus(List<Long> cashOrderIds);
    

}

