/**
 * Project Name:media-api<br>
 * File Name:RemoteStatisticstBackendService.java<br>
 * Package Name:cn.com.duiba.tuia.media.api.remoteservice<br>
 * Date:2016年10月10日下午4:18:04<br>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.<br>
 */
package cn.com.duiba.tuia.ssp.center.api.remote;

import cn.com.duiba.tuia.ssp.center.api.dto.MeidaActivitySlotStatisticsDto;
import cn.com.duiba.tuia.ssp.center.api.dto.ReqSlotLineStatisticsByPageDto;
import java.util.List;

import cn.com.duiba.tuia.ssp.center.api.dto.ActivityStatisticsDayDto;
import cn.com.duiba.tuia.ssp.center.api.dto.PageResultDto;
import cn.com.duiba.tuia.ssp.center.api.dto.ReqGetActivityData;
import cn.com.duiba.tuia.ssp.center.api.dto.ReqMediaAppStatisticsDto;
import cn.com.duiba.tuia.ssp.center.api.dto.ReqSlotStatisticsDto;
import cn.com.duiba.tuia.ssp.center.api.dto.RspGetActivityDetailData;
import cn.com.duiba.tuia.ssp.center.api.dto.RspMediaAppStatisticsDto;
import cn.com.duiba.tuia.ssp.center.api.dto.RspSlotStatisticsDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * ClassName: RemoteStatisticstBackendService <br/>
 * date: 2016年10月10日 下午4:18:04 <br/>
 * .
 *
 * @author xiawei
 * @version
 * @since JDK 1.6
 */
public interface RemoteStatisticstBackendService {

    /**
     * 统计广告位数据.
     *
     * @param req the req
     * @return the adsense data
     */
    DubboResult<PageResultDto<RspSlotStatisticsDto>> getAdsenseData(ReqSlotStatisticsDto req);

    /**
     * 统计媒体数据.
     *
     * @param req the req
     * @return the media data
     */
    DubboResult<PageResultDto<RspMediaAppStatisticsDto>> getMediaData(ReqMediaAppStatisticsDto req);
    
    /**
     * 分页查询活动明细数据.
     *
     * @param req the req
     * @return the media data
     */
    DubboResult<PageResultDto<RspGetActivityDetailData>> getActivityDetailDataByPage(ReqGetActivityData req);
    
    /**
     * 查询活动明细数据列表.<br>
     * 最多10000行记录<br>
     * 
     * @param req the req
     * @return the activity detail data list
     */
    DubboResult<List<RspGetActivityDetailData>> getActivityDetailDataList(ReqGetActivityData req);
    
    
    /**
     * 查询活动数据dto
     * @param req
     * @return
     */
    DubboResult<PageResultDto<ActivityStatisticsDayDto>> selectListByPageBySource (ReqGetActivityData req);

    DubboResult<Integer> selectMediaDataAmount(ReqMediaAppStatisticsDto reqMediaAppStatisticsDto);

    DubboResult<List<MeidaActivitySlotStatisticsDto>> selectListMediaDataByPage(ReqMediaAppStatisticsDto reqMediaAppStatisticsDto);

    DubboResult<List<MeidaActivitySlotStatisticsDto>> selectListSlotDataByPage(
            ReqSlotStatisticsDto reqSlotStatisticsDto);

    DubboResult<Integer> selectSlotDataAmout(ReqSlotStatisticsDto reqSlotStatisticsDto);

    DubboResult<List<MeidaActivitySlotStatisticsDto>> selectByDate(
            ReqSlotLineStatisticsByPageDto reqSlotLineStatisticsByPageDto);

    DubboResult<Integer> selectByDateAmount(
            ReqSlotLineStatisticsByPageDto reqSlotLineStatisticsByPageDto);

    DubboResult<List<MeidaActivitySlotStatisticsDto>> exportSlotDaily(
            ReqSlotStatisticsDto reqSlotStatisticsDto);
    
    DubboResult<List<MeidaActivitySlotStatisticsDto>> selectSdkUvAndPvData(ReqSlotLineStatisticsByPageDto param);
    
    
    DubboResult<List<MeidaActivitySlotStatisticsDto>> selectAppSdkPvAndUv(ReqMediaAppStatisticsDto param);
}
