/**
 * Project Name:ssp-center-api File Name:ReqUpdateMediaAccount.java Package Name:cn.com.duiba.tuia.ssp.center.api.dto
 * Date:2017年10月11日上午10:20:54 Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 */

package cn.com.duiba.tuia.ssp.center.api.dto;

import java.io.Serializable;
import java.util.Date;

import javax.validation.constraints.NotNull;

import org.apache.commons.lang.builder.ToStringBuilder;

import io.swagger.annotations.ApiModelProperty;

/**
 * ClassName:ReqUpdateMediaAccount <br/>
 * Function: 修改媒体用户账号信息 <br/>
 * Date: 2017年10月11日 上午10:20:54 <br/>
 * 
 * @author guyan
 * @version
 * @since JDK 1.6
 * @see
 */
public class ReqUpdateMediaAccount implements Serializable {

    /** 序列号 */
    private static final long serialVersionUID = -8124738365696486373L;

    /** 媒体账号 */
    @ApiModelProperty(value = "mediaId", required = true)
    @NotNull(message = "媒体ID不能为空")
    private Long              mediaId;

    /** 线下打款 */
    @ApiModelProperty(value = "isOffline", required = true)
    @NotNull(message = "线下打款不能为空")
    private Integer           isOffline;

    /** 媒体账号类别 */
    @ApiModelProperty(value = "accountType", required = true)
    private Integer           accountType;

    /** 允许访问数据状态：0:关闭，1:开启 */
    @ApiModelProperty(value = "允许访问数据状态: 0:关闭，1:开启", required = true)
    @NotNull(message = "允许访问数据状态不能为空")
    private Integer           accessDataStatus;

    @ApiModelProperty(value = "数据展示时间")
    private Date              startDate;

    public Long getMediaId() {
        return mediaId;
    }

    public void setMediaId(Long mediaId) {
        this.mediaId = mediaId;
    }

    public Integer getIsOffline() {
        return isOffline;
    }

    public void setIsOffline(Integer isOffline) {
        this.isOffline = isOffline;
    }

    public Integer getAccountType() {
        return accountType;
    }

    public void setAccountType(Integer accountType) {
        this.accountType = accountType;
    }

    public Integer getAccessDataStatus() {
        return accessDataStatus;
    }

    public void setAccessDataStatus(Integer accessDataStatus) {
        this.accessDataStatus = accessDataStatus;
    }

    public Date getStartDate() {
        return startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }
}
