package cn.com.duiba.tuia.ssp.center.api.remote;

import java.util.List;
import java.util.Set;

import cn.com.duiba.tuia.ssp.center.api.dto.MediaTagDto;
import cn.com.duiba.tuia.ssp.center.api.dto.TagLibraryDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

public interface RemoteMediaTagService {

	//添加标签（一级或者二级标签）,返回id
	DubboResult<Long> insert(String title, Long pid, Integer tagLevel);
	
	//获取所有标签，树形结构
	DubboResult<List<TagLibraryDto>> getAll();
	
	//标题模糊查询
	DubboResult<Set<String>> getLikeTitle(String title);
	
	//标题模糊查询获取id
	DubboResult<Set<Long>> getLikeId(String title);
	
	//删除一级标签
	DubboResult<Boolean> deleteTag1(Long id);
	
	//删除二级标签
	DubboResult<Boolean> deleteTag2(Long id);
	
	//标签的管理收敛于此类，即使是媒体的属性
	//媒体行业标签修改
	DubboResult<Boolean> updateMediaTag(MediaTagDto dto);
	
	//通过标签获取关联appid
	DubboResult<List<Long>> getAppIdsByTag(Long tagId);
	
	//获取媒体标签
	DubboResult<List<MediaTagDto>> getByAppIds(List<Long> appIds);
}
