/**
 * Project Name:media-manager-biz<br>
 * File Name:ReqAppDailyStatistics.java<br>
 * Package Name:cn.com.duiba.tuia.media.manager.model.req<br>
 * Date:2016年12月21日下午2:43:25<br>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.<br>
 */
package cn.com.duiba.tuia.ssp.center.api.dto;

import org.apache.commons.lang3.builder.ToStringBuilder;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * ClassName: ReqAppDailyStatistics <br/>
 * Function: 媒体每日数据请求对象. <br/>
 * date: 2016年12月21日 下午2:43:25 <br/>
 *
 * @author xiawei
 * @version
 * @since JDK 1.6
 */
@ApiModel
public class ReqAppDailyStatistics extends ReqDateQuery {

    /**序列号*/
    private static final long serialVersionUID = 2622662250199521271L;

    /** 媒体ID. */
    @ApiModelProperty(value = "媒ID", required = false)
    private Long   appId;

    /** The app name. */
    @ApiModelProperty(value = "媒体名称(用作导出)", required = false)
    private String appName;

    /** The platform. */
    @ApiModelProperty(value = "媒体所属平台(用作导出)", required = false)
    private String platform;

    /**
     * Gets the app id.
     *
     * @return the app id
     */
    public Long getAppId() {
        return appId;
    }

    /**
     * Sets the app id.
     *
     * @param appId the app id
     */
    public void setAppId(Long appId) {
        this.appId = appId;
    }

    /**
     * Gets the app name.
     *
     * @return the app name
     */
    public String getAppName() {
        return appName;
    }

    /**
     * Sets the app name.
     *
     * @param appName the app name
     */
    public void setAppName(String appName) {
        this.appName = appName;
    }

    /**
     * Gets the platform.
     *
     * @return the platform
     */
    public String getPlatform() {
        return platform;
    }

    /**
     * Sets the platform.
     *
     * @param platform the platform
     */
    public void setPlatform(String platform) {
        this.platform = platform;
    }

    /**
     * To string.
     *
     * @return the string
     */
    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

}
