package cn.com.duiba.tuia.ssp.center.api.remote;

import java.util.List;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.ssp.center.api.dto.AccountBankDto;
import cn.com.duiba.tuia.ssp.center.api.dto.ReqFinanceByPage;
import cn.com.duiba.tuia.ssp.center.api.dto.ReqUpdateFinanceDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * 媒体账户资金管理
 */
@AdvancedFeignClient
public interface RemoteAccountBankService {

    /**
     * 通过媒体用户ID查询媒体银行账户信息
     * @param media
     * @return
     */
    DubboResult<AccountBankDto> selectById(Long media);

    /**
     * 通过媒体用户ID集合,查询媒体银行账户信息集合
     * @param mediaIds
     * @return
     */
    DubboResult<List<AccountBankDto>> selectByIds(List<Long> mediaIds);

    /**
     *  更新媒体银行账户信息
     * @param req
     * @return
     */
    DubboResult<Boolean> update(AccountBankDto req);


    /**
     * 插入媒体银行账户信息
     * @param accountBankDto
     * @return
     */
    DubboResult<Boolean> insert(AccountBankDto accountBankDto);

    /**
     * 通过媒体用户ID和状态查询媒体银行账户信息,查询不到未提交审核和账户信息
     * @param req
     * @return
     */
    DubboResult<List<AccountBankDto>> selectSubmitStatus(ReqFinanceByPage req);

    /**
     * 通过媒体用户ID和状态查询审核中，审核通过和审核拒绝的媒体银行账户数量，
     * @param req
     * @return
     */
    DubboResult<Integer> selectSubmitStatusCount(ReqFinanceByPage req);
    
    /**
     * 
     * updateStatus:(修改审核状态). <br/>
     *
     * @author guyan
     * @param status
     * @param mediaId
     * @return
     * @since JDK 1.6
     */
    DubboResult<Boolean> updateStatus(ReqUpdateFinanceDto param);
}
