package cn.com.duiba.tuia.ssp.center.api.remote;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.ssp.center.api.dto.DomainInfoDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.List;

@AdvancedFeignClient
public interface RemoteDomainInfoService {

    DubboResult<DomainInfoDto> selectDomainBySlotId(Long slotId);

    DubboResult<Integer> selectCountByStrategyId(Long strategyId);

    DubboResult<List<Long>> selectSlotIdsByStrategyId(Long strategyId);

    DubboResult<Integer> deleteByStrategyId(Long strategyId);

    DubboResult<Integer> insert(List<Long> slotIds, Long strategyId);

    /**
     *
     * @param slotIds 广告位id集合
     * @param strategyId 关联策略id
     * @return 所有已经关联了其他策略的广告位
     */
    DubboResult<List<Long>> selectSlotIdsIsExist(List<Long> slotIds, Long strategyId);
}
