package cn.com.duiba.tuia.ssp.center.api.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.Date;

//激励审核对象
@ApiModel
public class MediaRewardScoreMonthDto extends RewardScoreBase implements Serializable {

    private static final long serialVersionUID = 6155902865831265654L;

    //主键id
    @ApiModelProperty(value = "质量分")
    private Long id;

    //媒体帐号id
    @ApiModelProperty(value = "媒体帐号ID", required = false)
    private Long mediaId;

    //媒体帐号邮箱
    @ApiModelProperty(value = "媒体帐号邮箱", required = false)
    private String email;

    @ApiModelProperty(value = "媒体帐号类型（0-未选 1-直客 2-代理）", required = false)
    private String accountType;

    //当前月份('2017-11')
    @ApiModelProperty(value = "当前月份('2017-11')", required = false)
    private String curMonth;

    //预计得分
    @ApiModelProperty(value = "预计得分", required = false)
    private Double predictScore;

    //实际得分
    @ApiModelProperty(value = "实际得分", required = false)
    private Integer realScore;

    //预计激励（单位：分）
    @ApiModelProperty(value = "预计激励（单位：分）", required = false)
    private Long predictReward;

    //实际激励（单位：分）
    @ApiModelProperty(value = "实际激励（单位：分）", required = false)
    private Long realReward;

    //修改激励金额（单位：分）
    @ApiModelProperty(value = "调整理由", required = false)
    private String modifyReward;

    //结算状态（'0-待结算，1-结算中，2-拒绝结算  3-已结算',）
    @ApiModelProperty(value = "结算状态（'0-待结算，1-结算中，2-拒绝结算  3-已结算',）", required = false)
    private Integer settleStatus;

    //拒绝原因
    @ApiModelProperty(value = "拒绝原因", required = false)
    private String refuseReason;

    //结算时间
    @ApiModelProperty(value = "结算时间", required = false)
    private Date cashTime;

    public Long getCashOrderId() {
        return cashOrderId;
    }

    public void setCashOrderId(Long cashOrderId) {
        this.cashOrderId = cashOrderId;
    }

    @ApiModelProperty(value = "提现单号", required = false)
    private Long cashOrderId;

    //媒体运营
    @ApiModelProperty(value = "媒体运营", required = false)
    private String mediaOperation;

    //风控运营
    @ApiModelProperty(value = "风控运营", required = false)
    private String riskControlOperation;

    //审核时间
    @ApiModelProperty(value = "审核时间", required = false)
    private Date auditTime;

    public Integer getAuditStatus() {
        return auditStatus;
    }

    public void setAuditStatus(Integer auditStatus) {
        this.auditStatus = auditStatus;
    }

    private Integer auditStatus;

    private Date gmtCreate;

    private Date gmtModified;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getMediaId() {
        return mediaId;
    }

    public void setMediaId(Long mediaId) {
        this.mediaId = mediaId;
    }

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email == null ? null : email.trim();
    }

    public String getAccountType() {
        return accountType;
    }

    public void setAccountType(String accountType) {
        this.accountType = accountType == null ? null : accountType.trim();
    }

    public String getCurMonth() {
        return curMonth;
    }

    public void setCurMonth(String curMonth) {
        this.curMonth = curMonth == null ? null : curMonth.trim();
    }

    public Double getPredictScore() {
        return predictScore;
    }

    public void setPredictScore(Double predictScore) {
        this.predictScore = predictScore;
    }

    public Integer getRealScore() {
        return realScore;
    }

    public void setRealScore(Integer realScore) {
        this.realScore = realScore;
    }

    public Long getPredictReward() {
        return predictReward;
    }

    public void setPredictReward(Long predictReward) {
        this.predictReward = predictReward;
    }

    public Long getRealReward() {
        return realReward;
    }

    public void setRealReward(Long realReward) {
        this.realReward = realReward;
    }

    public String getModifyReward() {
        return modifyReward;
    }

    public void setModifyReward(String modifyReward) {
        this.modifyReward = modifyReward;
    }

    public Integer getSettleStatus() {
        return settleStatus;
    }

    public void setSettleStatus(Integer settleStatus) {
        this.settleStatus = settleStatus;
    }

    public String getRefuseReason() {
        return refuseReason;
    }

    public void setRefuseReason(String refuseReason) {
        this.refuseReason = refuseReason == null ? null : refuseReason.trim();
    }

    public Date getCashTime() {
        return cashTime;
    }

    public void setCashTime(Date cashTime) {
        this.cashTime = cashTime;
    }

    public String getMediaOperation() {
        return mediaOperation;
    }

    public void setMediaOperation(String mediaOperation) {
        this.mediaOperation = mediaOperation == null ? null : mediaOperation.trim();
    }

    public String getRiskControlOperation() {
        return riskControlOperation;
    }

    public void setRiskControlOperation(String riskControlOperation) {
        this.riskControlOperation = riskControlOperation == null ? null : riskControlOperation.trim();
    }

    public Date getAuditTime() {
        return auditTime;
    }

    public void setAuditTime(Date auditTime) {
        this.auditTime = auditTime;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }
}
