package cn.com.duiba.tuia.ssp.center.api.dto;

import java.io.Serializable;
import java.util.Date;

import org.apache.commons.lang3.builder.ToStringBuilder;

public class DomainConfigDto implements Serializable {

    public static final int    PROTOCOL_HTTPS   = 0;

    public static final int    PROTOCOL_HTTP    = 1;

    public static final String PREFIX_ENGINE    = "engine.";

    public static final String prefix_activity  = "activity.";

    /**
     * 序列号
     */
    private static final long  serialVersionUID = 7948971555871778195L;

    private Long               id;

    /**
     * 活动投放引擎域名
     */
    private String             engUrl;

    /**
     * 活动域名
     */
    private String             actUrl;

    /**
     * 投放素材域名
     */
    private String             materialUrl;

    /**
     * 协议头类型
     */
    private Integer            protocolHeader;

    /**
     * 创建时间
     */
    private Date               gmtCreate;

    /**
     * 修改时间
     */
    private Date               gmtModified;

    /** 关联广告位id数量 */
    private Integer            slotCount;

    /** 策略名称 */
    private String             strategyName;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getEngUrl() {
        return engUrl;
    }

    public void setEngUrl(String engUrl) {
        this.engUrl = engUrl;
    }

    public String getActUrl() {
        return actUrl;
    }

    public void setActUrl(String actUrl) {
        this.actUrl = actUrl;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    public Integer getSlotCount() {
        return slotCount;
    }

    public void setSlotCount(Integer slotCount) {
        this.slotCount = slotCount;
    }

    public String getStrategyName() {
        return strategyName;
    }

    public void setStrategyName(String strategyName) {
        this.strategyName = strategyName;
    }

    public Integer getProtocolHeader() {
        return protocolHeader;
    }

    public void setProtocolHeader(Integer protocolHeader) {
        this.protocolHeader = protocolHeader;
    }

    public String getMaterialUrl() {
        return materialUrl;
    }

    public void setMaterialUrl(String materialUrl) {
        this.materialUrl = materialUrl;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }
}
