package cn.com.duiba.tuia.ssp.center.api.remote;

import java.util.List;
import java.util.Map;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.ssp.center.api.dto.ActivityManualPlanDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * 手动投放活动后台service
 */
@AdvancedFeignClient
public interface RemoteActivityManualBackendService {

	/**
	 * @param manualPlan
	 * @return
	 */
	DubboResult<Boolean> addActivityManualPlan(ActivityManualPlanDto manualPlan);

	/**
	 * @param planDto
	 * @return
	 */
	DubboResult<Boolean> modifyActivityManualPlan(ActivityManualPlanDto planDto);

	/**
	 * @param planDto
	 * @return
	 */
	DubboResult<Boolean> removeActivityManualPlan(ActivityManualPlanDto planDto);

	/**
	 * @param activityId
	 * @param activityType
	 * @return
	 */
	DubboResult<List<Long>> findActivityManualPlanSlot(Long activityId, Integer activityType);

	/**
	 * @param activityId
	 * @param activityType
	 * @return
	 */
	DubboResult<List<Long>> findActivityManualPlanSlotBySource(Long activityId, Integer source);
	
	/**
     * @param slotId
     * @return
     */
    DubboResult<List<ActivityManualPlanDto>> findActivityManualPlans(Long slotId, Map<Integer, String> actTypeMap);
}
