package cn.com.duiba.tuia.ssp.center.api.dto;

import org.apache.commons.lang.builder.ToStringBuilder;

/**
 * ActivityManualPlanDto
 */
public class ActivityManualPlanDto extends BaseDto {

    private static final long serialVersionUID = -5433858401741977928L;

    /** 未开始 */
    public static final int   STATUS_PREVIEW   = 0;

    /** 正在投放 */
    public static final int   STATUS_RELEASE   = 1;

    /** 已过期 */
    public static final int   STATUS_EXPIRED   = 2;

    /** 计划类型 0-活动 */
    public static final int   PLAN_TYPE_ACT    = 0;

    /** 计划类型 1-主会场 */
    public static final int   PLAN_TYPE_VENUE  = 1;

    private Long              activityId;

    private Integer           activityType;

    private String            activityName;

    private String            activityUrl;

    private Integer           activityStatus;

    private Long              operatorActivityId;

    private String            releaseTime;

    private Integer           status;

    private Long              slotId;

    private Integer           planType;

    /** 活动来源 0-兑吧 1-推啊 2-流量引导页*/
    private Integer           actSource;
    
    /** 手动投放 投放方式 0 轮询，1 定时*/
    private Integer launchType;


    /** 屏蔽活动状态 */
    private Integer           shieldActTagFlag;

    /** 活动皮肤类型 */
    private String           subType;

    /** 活动皮肤名称 */
    private String           skinName;

    /**
     * actSource.
     *
     * @return the actSource
     * @since JDK 1.6
     */
    public Integer getActSource() {
        return actSource;
    }

    /**
     * actSource.
     *
     * @param actSource the actSource to set
     * @since JDK 1.6
     */
    public void setActSource(Integer actSource) {
        this.actSource = actSource;
    }

    /**
     * planType.
     *
     * @return the planType
     * @since JDK 1.6
     */
    public Integer getPlanType() {
        return planType;
    }

    /**
     * planType.
     *
     * @param planType the planType to set
     * @since JDK 1.6
     */
    public void setPlanType(Integer planType) {
        this.planType = planType;
    }

    public Long getActivityId() {
        return activityId;
    }

    public void setActivityId(Long activityId) {
        this.activityId = activityId;
    }

    public Integer getActivityType() {
        return activityType;
    }

    public void setActivityType(Integer activityType) {
        this.activityType = activityType;
    }

    public String getActivityName() {
        return activityName;
    }

    public void setActivityName(String activityName) {
        this.activityName = activityName;
    }

    public String getActivityUrl() {
        return activityUrl;
    }

    public void setActivityUrl(String activityUrl) {
        this.activityUrl = activityUrl;
    }

    public Integer getActivityStatus() {
        return activityStatus;
    }

    public void setActivityStatus(Integer activityStatus) {
        this.activityStatus = activityStatus;
    }

    public Long getOperatorActivityId() {
        return operatorActivityId;
    }

    public void setOperatorActivityId(Long operatorActivityId) {
        this.operatorActivityId = operatorActivityId;
    }

    public String getReleaseTime() {
        return releaseTime;
    }

    public void setReleaseTime(String releaseTime) {
        this.releaseTime = releaseTime;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public Long getSlotId() {
        return slotId;
    }

    public void setSlotId(Long slotId) {
        this.slotId = slotId;
    }

    public Integer getLaunchType() {
		return launchType;
	}

	public void setLaunchType(Integer launchType) {
		this.launchType = launchType;
	}

    public Integer getShieldActTagFlag() {
        return shieldActTagFlag;
    }

    public void setShieldActTagFlag(Integer shieldActTagFlag) {
        this.shieldActTagFlag = shieldActTagFlag;
    }

    public String getSkinName() {
        return skinName;
    }

    public void setSkinName(String skinName) {
        this.skinName = skinName;
    }

    public String getSubType() {
        return subType;
    }

    public void setSubType(String subType) {
        this.subType = subType;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }
}
