/**
 * Project Name:media-biz File Name:Media.java Package Name:cn.com.duiba.tuia.media.domain Date:2016年9月26日上午11:32:48
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 */
/**
 * 
 */

package cn.com.duiba.tuia.ssp.center.api.dto;

import org.apache.commons.lang.builder.ToStringBuilder;

/**
 * 媒体信息.
 *
 * @author: guyan
 * @version:
 */

public class MediaAppDto extends BaseDto {

    /** 序列ID. */
    private static final long  serialVersionUID           = 6133335694581286778L;

    /** 开通状态:0-待审核. */
    public static final int    MEDIA_APP_CHECKING         = 0;
    /** 开通状态:1-审核通过. */
    public static final int    MEDIA_APP_CHECK_PASS       = 1;
    /** 开通状态:2-审核拒绝. */
    public static final int    MEDIA_APP_CHECK_FAIL       = 2;

    /** 系统平台:Android. */
    public static final String MEDIA_APP_PLATFORM_ANDROID = "Android";
    /** 系统平台:iOS. */
    public static final String MEDIA_APP_PLATFORM_IOS     = "iOS";
    
    /**全部关闭状态*/
    public static final Integer ALL_SLOT_CLOSED_TRUE= 0;
    
    /**未全部关闭状态*/
    public static final Integer ALL_SLOT_CLOSED_FLASE= 1;
    
    /**未冻结*/
    public static final int    NO_FROZEN_STATUS=0;
    
    /**已冻结*/
    public static final int    IS_FROZEN_STATUS=1;

    /** 媒体用户ID. */
    private Long               mediaId;
    /** 媒体ID. */
    private Long               appId;
    /** 媒体标识. */
    private String             appKey;
    /** 媒体名称. */
    private String             appName;
    /** app秘钥 */
    private String             appSecret;
    /** 行业. */
    private String             industry;
    /** 开通状态:0-待审核;1-审核通过;2-审核拒绝. */
    private Integer            checkStatus;
    /** 验证状态:0-待验证;1-验证通过 */
    private Integer            verifyStatus;
    /** 系统平台:Android或iOS. */
    private String             platform;
    /** 程序主包名. */
    private String             appPackage;
    /** 媒体关键词. */
    private String             appKeyWords;
    /** 媒体简介. */
    private String             description;
    /** 下载地址. */
    private String             downloadUrl;

    /**广告位全部关闭状态*/
    private Integer            allSlotClosed;
    
    /** 冻结状态 */
    private Integer             frozenStatus;

    /** 冻结原因 */
    private String              frozenReason;
    
    //标签名称：一级-二级
    private String tagName;
    
    /**账号类别: 0-未选 1-直客 2-代理*/
    private Integer accountType;
    /** 流量标签名称 **/
    private String flowTagName;
    /** 流量分级标签名称 **/
    private String gradeTagName;

    /** 公众账号名称 */
    private String             officialAccountName;

    /**公众号类别：0:订阅号，1：服务号*/
    private Integer            officialAccountType;
    
    /**公众号主体，0:企业，1:个人*/
    private Integer            officialAccountSubject;


    public Long getMediaId() {
        return mediaId;
    }

    public void setMediaId(Long mediaId) {
        this.mediaId = mediaId;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public String getAppKey() {
        return appKey;
    }

    public String getAppSecret() {
        return appSecret;
    }

    public void setAppSecret(String appSecret) {
        this.appSecret = appSecret;
    }

    public void setAppKey(String appKey) {
        this.appKey = appKey;
    }

    public String getAppName() {
        return appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public String getIndustry() {
        return industry;
    }

    public void setIndustry(String industry) {
        this.industry = industry;
    }

    public Integer getCheckStatus() {
        return checkStatus;
    }

    public void setCheckStatus(Integer checkStatus) {
        this.checkStatus = checkStatus;
    }

    public String getPlatform() {
        return platform;
    }

    public void setPlatform(String platform) {
        this.platform = platform;
    }

    public String getAppPackage() {
        return appPackage;
    }

    public void setAppPackage(String appPackage) {
        this.appPackage = appPackage;
    }

    public String getAppKeyWords() {
        return appKeyWords;
    }

    public void setAppKeyWords(String appKeyWords) {
        this.appKeyWords = appKeyWords;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDownloadUrl() {
        return downloadUrl;
    }

    public void setDownloadUrl(String downloadUrl) {
        this.downloadUrl = downloadUrl;
    }

    public Integer getAllSlotClosed() {
        return allSlotClosed;
    }

    public void setAllSlotClosed(Integer allSlotClosed) {
        this.allSlotClosed = allSlotClosed;
    }

	public Integer getVerifyStatus() {
		return verifyStatus;
	}

	public void setVerifyStatus(Integer verifyStatus) {
		this.verifyStatus = verifyStatus;
	}
	
	public Integer getFrozenStatus() {
        return frozenStatus;
    }

    
    public void setFrozenStatus(Integer frozenStatus) {
        this.frozenStatus = frozenStatus;
    }

    
    public String getFrozenReason() {
        return frozenReason;
    }

    
    public void setFrozenReason(String frozenReason) {
        this.frozenReason = frozenReason;
    }

	public String getTagName() {
		return tagName;
	}

	public void setTagName(String tagName) {
		this.tagName = tagName;
	}
    
    public Integer getAccountType() {
	   return accountType;
    }

	    
    public void setAccountType(Integer accountType) {
	   this.accountType = accountType;
	}
   
	public String getFlowTagName() {
		return flowTagName;
	}

	public void setFlowTagName(String flowTagName) {
		this.flowTagName = flowTagName;
	}

    public String getGradeTagName() {
        return gradeTagName;
    }

    public void setGradeTagName(String gradeTagName) {
        this.gradeTagName = gradeTagName;
    }
	
    public String getOfficialAccountName() {
        return officialAccountName;
    }

    public void setOfficialAccountName(String officialAccountName) {
        this.officialAccountName = officialAccountName;
    }

    public Integer getOfficialAccountType() {
        return officialAccountType;
    }

    public void setOfficialAccountType(Integer officialAccountType) {
        this.officialAccountType = officialAccountType;
    }

    public Integer getOfficialAccountSubject() {
        return officialAccountSubject;
    }

    public void setOfficialAccountSubject(Integer officialAccountSubject) {
        this.officialAccountSubject = officialAccountSubject;
    }
    
    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

}
