package cn.com.duiba.tuia.ssp.center.api.dto;

import java.util.Date;
import java.util.List;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

import org.springframework.format.annotation.DateTimeFormat;

import com.fasterxml.jackson.annotation.JsonFormat;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 通知（站内信）DTO
 * 
 * @author songjiaxing
 *
 */
@ApiModel
public class NoticeDto extends BaseDto {

	private static final long serialVersionUID = 8712355321169783096L;

	/**
	 * 通知主题
	 */
	@ApiModelProperty(value = "通知标题",required=true)
	@NotNull(message="通知主题不能为空")
	private String title;

	/**
	 * 发件团队
	 */
	@ApiModelProperty(value = "发件团队",required=true)
	@NotNull(message="发件团队不能为空")
	private String sender;

	/**
	 * 定向方式（0：全部，1：定向媒体）
	 */
	@ApiModelProperty(value = "定向方式（0：全部，1：定向媒体）",required=true)
	@NotNull(message="定向方式不能为空")
	private Integer directType;

	/**
	 * 发送类型（0：立即发送，1：定时发送）
	 */
	@ApiModelProperty(value = "发送类型（0：立即发送，1：定时发送）",required=true)
	@NotNull(message="发送类型不能为空")
	private Integer sendType;

	/**
	 * 发送时间
	 */
	@ApiModelProperty(value = "发送时间")
	@DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	@JsonFormat(pattern="yyyy-MM-dd HH:mm:ss",timezone = "GMT+8")
	private Date sendTime;

	/**
	 * 送达状态：（0：未送达，1：已送达）
	 */
	@ApiModelProperty(value = "送达状态：（0：未送达，1：已送达）")
	private Integer sendStatus;
	
	/**
	 * 通知内容
	 */
	@ApiModelProperty(value = "通知内容",required=true)
	@NotNull(message="通知内容不能为空")
	@Size(max = 8000, message="通知内容长度过长")
	private String content;

	/**
	 * 收件人(mediaId以‘,’隔开)
	 */
	@ApiModelProperty(value = "收件人(mediaId以‘,’隔开)")
	private String receiver;

	/**
	 * 扩展字段，通知类型（0：系统通知，1：运营通知）
	 */
	private Integer noticeType;

	/**
	 * 是否删除 1：已删除 0：未删除
	 */
	private Integer isDelete;

	/**
	 * 读取状态（0：接收未读，1：接收已读）
	 */
	@ApiModelProperty(value = "读取状态（0：接收未读，1：接收已读）")
	private Integer readStatus;

	@ApiModelProperty(value = "收件媒体列表")
	private List<NoticeAccountDto> noticeAccountDtos;
	
	@ApiModelProperty(value = "下一条通知")
	private NoticeDto nextNotice;

	public String getTitle() {
		return title;
	}

	public void setTitle(String title) {
		this.title = title;
	}

	public String getSender() {
		return sender;
	}

	public void setSender(String sender) {
		this.sender = sender;
	}

	public Integer getDirectType() {
		return directType;
	}

	public void setDirectType(Integer directType) {
		this.directType = directType;
	}

	public Date getSendTime() {
		return sendTime;
	}

	public void setSendTime(Date sendTime) {
		this.sendTime = sendTime;
	}

	public String getContent() {
		return content;
	}

	public void setContent(String content) {
		this.content = content;
	}

	public String getReceiver() {
		return receiver;
	}

	public void setReceiver(String receiver) {
		this.receiver = receiver;
	}

	public Integer getNoticeType() {
		return noticeType;
	}

	public void setNoticeType(Integer noticeType) {
		this.noticeType = noticeType;
	}

	public Integer getIsDelete() {
		return isDelete;
	}

	public void setIsDelete(Integer isDelete) {
		this.isDelete = isDelete;
	}

	public Integer getReadStatus() {
		return readStatus;
	}

	public void setReadStatus(Integer readStatus) {
		this.readStatus = readStatus;
	}

	public Integer getSendType() {
		return sendType;
	}

	public void setSendType(Integer sendType) {
		this.sendType = sendType;
	}

	public List<NoticeAccountDto> getNoticeAccountDtos() {
		return noticeAccountDtos;
	}

	public void setNoticeAccountDtos(List<NoticeAccountDto> noticeAccountDtos) {
		this.noticeAccountDtos = noticeAccountDtos;
	}

	public Integer getSendStatus() {
		return sendStatus;
	}

	public void setSendStatus(Integer sendStatus) {
		this.sendStatus = sendStatus;
	}

	public NoticeDto getNextNotice() {
		return nextNotice;
	}

	public void setNextNotice(NoticeDto nextNotice) {
		this.nextNotice = nextNotice;
	}

}
