package cn.com.duiba.tuia.ssp.center.api.remote;

import java.util.List;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.ssp.center.api.dto.ActivityCenterDto;
import cn.com.duiba.tuia.ssp.center.api.dto.ActivityDto;
import cn.com.duiba.tuia.ssp.center.api.dto.PlugBuoyConfigDto;
import cn.com.duiba.tuia.ssp.center.api.dto.ReqActivityCenterDto;
import cn.com.duiba.tuia.ssp.center.api.dto.RspActivityCenterDto;
import cn.com.duiba.tuia.ssp.center.api.dto.SlotDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

@AdvancedFeignClient
public interface RemoteActivityCenterService {
    /**
     * 置顶活动或取消置顶，任意参数为null返回0<br/>
     *
     * @param activityId  活动id
     * @param source     活动来源 0 兑吧 1 推啊 2 流量引导页
     * @param status     0 不置顶 1 置顶
     * @return
     */
    DubboResult<Integer> updateIsTopStatus(Long activityId, Integer source, Integer status);

    /**
     * 查询活动中心的活动，提供没媒体管理后台<br/>
     *
     * @param req
     * @return
     */
    DubboResult<List<ActivityCenterDto>> selectLists(ReqActivityCenterDto req);

    /**
     * 查询活动中心活动，提供给活动中心,查询所有开启未删除的活动<br/>
     * 如果屏蔽后数量少于10个则不屏蔽，否者执行屏蔽策略</br>
     * @param slotId 广告位Id 影响对应的屏蔽策略
     * @return
     */
    DubboResult<List<RspActivityCenterDto>> selectAllLists(Long slotId);

    /**
     * 移除一条活动，参数任意为null，返回0<br/>
     *
     * @param activityId  活动id
     * @param source      活动来源 0 兑吧 1 推啊 2 流量引导页
     * @return
     */
    DubboResult<Integer> delete(Long activityId, Integer source);

    /**
     * 批量插入活动，如果活动已存在则不进行插入也不进行更新<br/>
     *
     * @param activityIds  活动id集合
     * @param source       活动来源 0 兑吧 1 推啊 2 流量引导页
     * @return
     */
    DubboResult<Integer> insert(List<Long> activityIds, Integer source);
    
    /**
     * 
     * 修改活动标签
     *
     * @author guyan
     * @param activityId:活动标签
     * @param source:活动来源
     * @param tag:活动标签
     * @return
     * @since JDK 1.6
     */
    DubboResult<Boolean> updateActivityTag(Long activityId,Integer source,String tag);

    /**
     *
     * @param slotId 广告位ID
     * @param source 活动来源
     * @return   可投放的活动，且定向为当前广告位媒体的活动也可以投放
     */
    DubboResult<List<Long>> getAvilPlanListBySource(Long slotId,Integer source);

    /**
     *  删除，关闭的活动
     * @param planIds 推广计划ID
     * @return 所有可用的推广计划ID
     */
    DubboResult<List<ActivityDto>> getAvilPlanList(List<Long> planIds);

    /**
     *
     * @param activityIds 活动id集合
     * @param source       活动来源
     * @return            可用活动集合
     */
    DubboResult<List<ActivityDto>> getAvailablePlanList(List<Long> activityIds,Integer source);

    /**
     *
     * @param activityDto 其中activityId和source必填，其他选项必填一个或多个
     * @return 成功更新条数
     */
    DubboResult<Integer> update(ActivityDto activityDto);

    /**
     *
     * @param activityIds 活动ID
     * @param source 活动来源
     * @return 所有未删除活动
     */
    DubboResult<List<ActivityDto>> getByActivityIds(List<Long> activityIds, Integer source);

    /**
     *
     * @param activityId 活动ID
     * @param source     活动来源
     * @return           定向的媒体app id列表，如果为空返回空集合
     */
    DubboResult<List<Long>> getDirectedAppByAct(Long activityId, Integer source);

    /**
     *
     * @return 返回特殊媒体集合
     */
    DubboResult<List<Long>> getSpeApp();

    /**
     *
     * @param slotIds 广告位ID集合
     * @return  所有数据存在的广告位ID，包含删除冻结等广告位
     */
    DubboResult<List<SlotDto>> getListDetail(List<Long> slotIds);

    /**
     *  前模糊查询广告位列表
     * @param name 广告位名称
     * @return 广告位详情
     */
    DubboResult<List<SlotDto>> getSlotListByName(String name);

    /**
     *  根据appId和source查询对应的定向到此媒体的对应类型的活动
     * @param appId   媒体ID
     * @param source  活动来源
     * @return   定向到此媒体的活动列表
     */
    DubboResult<List<ActivityDto>> getDirectActByAppId(Long appId,Integer source);

    /**
     *
     * @param slotId 广告位ID
     * @return 如果广告位无对应的配置则返回null
     */
    DubboResult<PlugBuoyConfigDto> getPlugAndBuoyConfigBySlotId(Long slotId);


}
