package cn.com.duiba.tuia.ssp.center.api.remote;

import java.util.List;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.ssp.center.api.dto.MediaCashBillDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * 媒体提现单发票信息service
 * 
 *
 */
@AdvancedFeignClient
public interface RemoteMediaCashBillService {

	/**
	 * 根据提现单号查询发票列表
	 * @param orderId 提现单号
	 * @return
	 */
	public DubboResult<List<MediaCashBillDto>> getBillsByOrderId(Long orderId);

	/**
	 * 插入一条发票信息
	 * @param mediaCashBillDto
	 * @return
	 */
	public DubboResult<Boolean> addBill(MediaCashBillDto mediaCashBillDto);

	/**
	 * 更新一条发票信息
	 * @param mediaCashBillDto
	 * @return
	 */
	public DubboResult<Boolean> updateBill(MediaCashBillDto mediaCashBillDto);

	/**
	 * 根据id查询对应发票
	 * @param id
	 * @return
	 */
	public DubboResult<MediaCashBillDto> getBillById(Long id);
	
	/**
	 * 批量添加账单数据
	 * 
	 * @param billList
	 * @return
	 * @since JDK 1.6
	 */
	public DubboResult<Boolean> addBatchBillList(List<MediaCashBillDto> billList);
	
	 /**
     * 通过发票id批量删除发票信息
     * 
     * @param billIds
     * @return
     * @since JDK 1.6
     */
    public DubboResult<Boolean> deleteCashBillById(Long cashOrderId);
}
