/**
 * Project Name:ssp-center-api
 * File Name:selectRangeType.java
 * Package Name:cn.com.duiba.tuia.ssp.center.api.constant
 * Date:2017年12月18日上午11:23:29
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.tuia.ssp.center.api.constant;

import java.util.List;

import org.apache.commons.collections.CollectionUtils;

import cn.com.duiba.tuia.ssp.center.api.dto.ReqSelectRangeDto;

/**
 * ClassName:selectRangeType <br/>
 * Function: 查询区间. <br/>
 * Date:     2017年12月18日 上午11:23:29 <br/>
 * @author   guyan
 * @version  
 * @see 	 
 */
public enum SelectRangeType {
   
    SELECT_RANGE_TYPE_0(0, 0L),
    
    SELECT_RANGE_TYPE_1(1, 1000L),
    
    SELECT_RANGE_TYPE_2(2, 5000L),
    
    SELECT_RANGE_TYPE_3(3, 10000L);
    
    private Integer type;

    private Long value;


    SelectRangeType(Integer type, Long value) {
        this.type = type;
        this.value = value;
    }

    public Integer getType() {
        return type;
    }

    public Long getValue() {
        return value;
    }
    
    public static boolean equalsType(Integer type) {
        return type.equals(type);
    }
    
    public static <Q extends ReqSelectRangeDto> void filter(Q param) {
        List<Integer> range=param.getSelectRangeType();
        if (CollectionUtils.isNotEmpty(range)) {
            if (range.size()==4) {
                return;
            }
            Integer type=range.get(range.size()-1); //查询类型
            if (equalsType(type)) {
                switch (type) {
                    case 0:
                        buildSelectAmount(param,range,0L);
                        param.setEndMaxAmount(100000L);
                        break;
                    case 1:
                        buildSelectAmount(param,range,100000L);
                        param.setEndMaxAmount(500000L);
                        break;
                    case 2:
                        buildSelectAmount(param,range,500000L);
                        param.setEndMaxAmount(1000000L);
                        break;
                    case 3:
                        param.setStartMinAmount(1000000L);
                        break;
                    default:
                        break;
                  }
             }
        }
    }
    
    /**
     * buildSelectAmount:(构建查询金额). <br/>
     *
     * @author guyan
     * @param param
     * @param range
     * @param amount
     */
    private static <Q extends ReqSelectRangeDto> void buildSelectAmount(Q param,List<Integer> range,Long amount){
        if (range.size()==1) {
              param.setStartMinAmount(amount);
         }
     }
}

