/**
 * Project Name:ssp-center-api
 * File Name:SelectRange.java
 * Package Name:cn.com.duiba.tuia.ssp.center.api.dto
 * Date:2017年12月18日下午3:11:34
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.tuia.ssp.center.api.dto;

import java.util.List;

import org.apache.commons.lang.builder.ToStringBuilder;

import io.swagger.annotations.ApiModelProperty;

/**
 * ClassName:SelectRange <br/>
 * Function: 查询区间. <br/>
 * Date:     2017年12月18日 下午3:11:34 <br/>
 * @author   guyan
 * @version  
 * @see 	 
 */
public class ReqSelectRangeDto extends ReqDateQuery {
    
    /**序列号 */
    private static final long serialVersionUID = -5785763489950366327L;

    /**查询区间*/
    @ApiModelProperty(value = "查询区间类型", required = false)
    private List<Integer> selectRangeType; 
    
    /**查询区间开始金额*/
    @ApiModelProperty(value = "查询区间开始金额", required = false)
    private Long      startMinAmount;
    
    /**查询区间结束金额*/
    @ApiModelProperty(value = "查询区间结束金额", required = false)
    private Long      endMaxAmount;
    
    
    public List<Integer> getSelectRangeType() {
        return selectRangeType;
    }

    
    public void setSelectRangeType(List<Integer> selectRangeType) {
        this.selectRangeType = selectRangeType;
    }

    
    public Long getStartMinAmount() {
        return startMinAmount;
    }

    
    public void setStartMinAmount(Long startMinAmount) {
        this.startMinAmount = startMinAmount;
    }

    
    public Long getEndMaxAmount() {
        return endMaxAmount;
    }

    
    public void setEndMaxAmount(Long endMaxAmount) {
        this.endMaxAmount = endMaxAmount;
    }
    
    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

}

