package cn.com.duiba.tuia.ssp.center.api.remote;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.ssp.center.api.constant.PrePayStatus;
import cn.com.duiba.tuia.ssp.center.api.dto.PageDto;
import cn.com.duiba.tuia.ssp.center.api.dto.PrePayDto;
import cn.com.duiba.tuia.ssp.center.api.dto.PrePayRecordDto;
import cn.com.duiba.tuia.ssp.center.api.dto.ReqPrePayPage;
import java.util.List;

@AdvancedFeignClient
public interface RemotePrePayService {

    /**
     * 查询账号下所有未抵扣已打款的账单
     * @param mediaId
     * @return
     */
    List<PrePayDto> selectPrePayAmountByMediaId(Long mediaId);

    /**
     * 查询所有正在审核中订单,防止审核中订单被重复添加
     * @param appId
     * @return
     */
    Integer selectCheckOrderCount(Long appId);

    PageDto<PrePayDto> getPrePayList(ReqPrePayPage req);

    Integer updateStatus(PrePayStatus nowStatus, PrePayStatus nextStatus, Long orderId, String rejectReason);

    Integer insert(PrePayDto req);
    /** 查询媒体下所有的预付款单 */
    Integer selectCountByMediaId(Long mediaId);

    /** 分页查询媒体下预付款单 */
    List<PrePayDto> selectPageListByMediaId(Long mediaId, Integer start, Integer limit);

    List<PrePayDto> selectByCashOrderId(Long cashOrderId);

    List<PrePayDto> selectByCashOrderIds(List<Long> cashOrderIds);

    Long selectPrePayBalance(Long appId);

    PrePayDto selectByOrderId(Long orderId);

    Integer insertRecord(PrePayRecordDto req);

}
