package cn.com.duiba.tuia.ssp.center.api.remote;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.ssp.center.api.dto.ReqSubAccountIncome;
import cn.com.duiba.tuia.ssp.center.api.dto.ReqSubAccountMoney;
import cn.com.duiba.tuia.ssp.center.api.dto.SubAccountMoneyDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.List;

@AdvancedFeignClient
public interface RemoteSubAccountMoneyService {

    /**
     * 插入一条记录，如果记录已经存在，则更新收入
     * @param dto
     * @return
     */
    DubboResult<Integer> insertOrUpdate(SubAccountMoneyDto dto);

    DubboResult<Boolean> updateMoneyTask();

    DubboResult<List<SubAccountMoneyDto>> getListByReq(ReqSubAccountMoney req);

    DubboResult<List<SubAccountMoneyDto>> getAppIncomeByReq(ReqSubAccountIncome req);

    DubboResult<List<SubAccountMoneyDto>> getAppDailyIncomeByReq(ReqSubAccountIncome req);

    DubboResult<List<SubAccountMoneyDto>> getSlotIncomeByReq(ReqSubAccountIncome req);

    DubboResult<List<SubAccountMoneyDto>> getSlotDailyIncomeByReq(ReqSubAccountIncome req);

    DubboResult<List<SubAccountMoneyDto>> getDailyIncomeByReq(ReqSubAccountIncome req);
}
