/**
 * Project Name:media-api File Name:MediaAppCheckRecordDto.java Package Name:cn.com.duiba.tuia.media.api.dto
 * Date:2016年10月18日上午10:33:18 Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 */

package cn.com.duiba.tuia.ssp.center.api.dto;

import org.apache.commons.lang.builder.ToStringBuilder;

/**
 * ClassName:MediaAppCheckRecordDto <br/>
 * Function: 媒体app审核记录. <br/>
 * Date: 2016年10月18日 上午10:33:18 <br/>
 * 
 * @author guyan
 * @version
 * @since JDK 1.6
 * @see
 */
public class MediaAppCheckRecordDto extends BaseDto {

    /** 序列号 */
    private static final long serialVersionUID     = 4609736321257034886L;

    /** 开通状态:1-审核通过. */
    public static final int   MEDIA_APP_CHECK_PASS = 1;
    /** 开通状态:2-审核拒绝. */
    public static final int   MEDIA_APP_CHECK_FAIL = 2;

    /** 账号ID */
    private Long              mediaId;
    /** 媒体ID */
    private Long              appId;
    /** 审核动作类型,1-审核通过;2-审核拒绝 */
    private Integer           checkType;
    /** 拒绝理由 */
    private String            reason;

    public Long getMediaId() {
        return mediaId;
    }

    public void setMediaId(Long mediaId) {
        this.mediaId = mediaId;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public Integer getCheckType() {
        return checkType;
    }

    public void setCheckType(Integer checkType) {
        this.checkType = checkType;
    }

    public String getReason() {
        return reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

}
