package cn.com.duiba.tuia.ssp.center.api.dto;

import java.util.List;

import org.apache.commons.lang.builder.ToStringBuilder;

/**
 * ClassName: MediaCashOrderDto <br/>
 * Function: 提现单. <br/>
 * date: 2017年5月5日 上午11:27:57 <br/>
 *
 * @version
 * @since JDK 1.6
 */
public class MediaCashOrderDto extends BaseDto {
    
    /** 序列号 */
    private static final long      serialVersionUID = 8895863425584026044L;
    
    /**未提现*/
    public static final int  ORDER_CHECK_STATUS_NO=0;
    
    /**审核中*/
    public  static final int ORDER_CHECK_STATUS_AUDIT=1;
    
    /**提现拒绝*/
    public  static final int ORDER_CHECK_STATUS_REFUSE=2;
    
    /**提现通过*/
    public  static final int ORDER_CHECK_STATUS_PASS=3;
    
    /**已打款*/
    public  static final int ORDER_CHECK_STATUS_PLAYED=4;
    
    
    
    /** 用户ID */
    private Long                   mediaId;

    /** 提现单号 */
    private Long                   cashOrderId;

    /** 联系人 */
    private String                 linkman;

    /** 联系人方式 */
    private String                 linkmanPhone;

    /** 邮寄地址 */
    private String                 senderAddr;

    /** 发票数量 */
    private Integer                billCount;

    /** 审核状态 */
    private Integer                checkStatus;

    /** 审核信息 */
    private String                 checkMsg;

    /** 邮寄类型 */
    private Integer                sendType;

    /** 所填发票金额 */
    private Long                fillInAmount;

    /** 发票信息 */
    private List<MediaCashBillDto> mediaCashBillDtos;

    /** 需要回寄结算单:0-不需要回寄结算单，1-需要回寄结算单 */
    private Integer                needBackSettlement;

    /** 银行名称 */
    private String                 bankName;

    /** 支行名称 */
    private String                 branchName;

    /** 公司名称 */
    private String                 financeCompanyName;

    /** 银行卡号 */
    private String                 cardNumber;

    /** 开户人 */
    private String                 openMan;

    /** 账号邮箱 */
    private String                 email;

    /** 账号类型 */
    private Integer                roleType;
    
    /** 媒体请款清单状态：0:未请款，1:已请款*/
    private Integer cashRequirementStatus;

    public Integer getNeedBackSettlement() {
        return needBackSettlement;
    }

    
    public void setNeedBackSettlement(Integer needBackSettlement) {
        this.needBackSettlement = needBackSettlement;
    }

    public Long getMediaId() {
        return mediaId;
    }

    public void setMediaId(Long mediaId) {
        this.mediaId = mediaId;
    }

    public String getLinkman() {
        return linkman;
    }

    public void setLinkman(String linkman) {
        this.linkman = linkman;
    }

    public String getLinkmanPhone() {
        return linkmanPhone;
    }

    public void setLinkmanPhone(String linkmanPhone) {
        this.linkmanPhone = linkmanPhone;
    }

    public String getSenderAddr() {
        return senderAddr;
    }

    public void setSenderAddr(String senderAddr) {
        this.senderAddr = senderAddr;
    }

    public Integer getBillCount() {
        return billCount;
    }

    public void setBillCount(Integer billCount) {
        this.billCount = billCount;
    }

    public Integer getCheckStatus() {
        return checkStatus;
    }

    public void setCheckStatus(Integer checkStatus) {
        this.checkStatus = checkStatus;
    }

    public String getCheckMsg() {
        return checkMsg;
    }

    public void setCheckMsg(String checkMsg) {
        this.checkMsg = checkMsg;
    }

    public Integer getSendType() {
        return sendType;
    }

    public void setSendType(Integer sendType) {
        this.sendType = sendType;
    }

    public List<MediaCashBillDto> getMediaCashBillDtos() {
        return mediaCashBillDtos;
    }

    public void setMediaCashBillDtos(List<MediaCashBillDto> mediaCashBillDtos) {
        this.mediaCashBillDtos = mediaCashBillDtos;
    }

    public Long getCashOrderId() {
        return cashOrderId;
    }

    public void setCashOrderId(Long cashOrderId) {
        this.cashOrderId = cashOrderId;
    }

    public Long getFillInAmount() {
        return fillInAmount;
    }

    public void setFillInAmount(Long fillInAmount) {
        this.fillInAmount = fillInAmount;
    }
    
    /**
     * 获取提现订单状态文案
     * 
     * @param status 提现订单状态编码
     * @return 提现订单状态文案
     */
    public static String getStatusText(Integer status) {
        String text = "状态未定义";
        if (status != null) {
            switch (status) {
                case ORDER_CHECK_STATUS_AUDIT:
                    text = "审核中";
                    break;

                case ORDER_CHECK_STATUS_REFUSE:
                    text = "提现拒绝";
                    break;

                case ORDER_CHECK_STATUS_PASS:
                    text = "提现通过";
                    break;
                 
                case ORDER_CHECK_STATUS_PLAYED:
                    text = "已打款";
                    break;

                default:
                    break;
            }
        }
        return text;
    }

    public String getBankName() {
        return bankName;
    }

    public void setBankName(String bankName) {
        this.bankName = bankName;
    }

    public String getBranchName() {
        return branchName;
    }

    public void setBranchName(String branchName) {
        this.branchName = branchName;
    }

    public String getFinanceCompanyName() {
        return financeCompanyName;
    }

    public void setFinanceCompanyName(String financeCompanyName) {
        this.financeCompanyName = financeCompanyName;
    }

    public String getCardNumber() {
        return cardNumber;
    }

    public void setCardNumber(String cardNumber) {
        this.cardNumber = cardNumber;
    }

    public String getOpenMan() {
        return openMan;
    }

    public void setOpenMan(String openMan) {
        this.openMan = openMan;
    }

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public Integer getRoleType() {
        return roleType;
    }

    public void setRoleType(Integer roleType) {
        this.roleType = roleType;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }


    
    public Integer getCashRequirementStatus() {
        return cashRequirementStatus;
    }


    
    public void setCashRequirementStatus(Integer cashRequirementStatus) {
        this.cashRequirementStatus = cashRequirementStatus;
    }
}
