package cn.com.duiba.tuia.ssp.center.api.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.Date;

import org.springframework.format.annotation.DateTimeFormat;

@ApiModel
public class MediaRewardScoreDayDto extends RewardScoreBase implements Serializable {

    private static final long serialVersionUID = -5961640151850405807L;

    @ApiModelProperty(value = "主键ID", required = false)
    private Long id;

    @ApiModelProperty(value = "媒体帐号ID", required = false)
    private Long mediaId;

    @ApiModelProperty(value = "媒体帐号邮箱", required = false)
    private String email;

    @ApiModelProperty(value = "媒体帐号类型（ 0-未选 1-直客 2-代理）", required = false)
    private String accountType;

    @ApiModelProperty(value = "当前日期（'2017-11-11'）", required = true)
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date curDate;

    private Date gmtCreate;

    private Date gmtModified;

    //预计得分
    private Double predictScore;

    public Double getPredictScore() {
        return predictScore;
    }

    public void setPredictScore(Double predictScore) {
        this.predictScore = predictScore;
    }


    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getMediaId() {
        return mediaId;
    }

    public void setMediaId(Long mediaId) {
        this.mediaId = mediaId;
    }

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email == null ? null : email.trim();
    }

    public String getAccountType() {
        return accountType;
    }

    public void setAccountType(String accountType) {
        this.accountType = accountType == null ? null : accountType.trim();
    }

    public Date getCurDate() {
        return curDate;
    }

    public void setCurDate(Date curDate) {
        this.curDate = curDate;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }
}
