/**
 * 文件名： ByDateQueryReq.java 此类描述的是： 作者: leiliang 创建时间: 2016年4月21日 上午10:54:21
 */
package cn.com.duiba.tuia.ssp.center.api.dto;

import io.swagger.annotations.ApiModelProperty;

import java.util.Date;

import org.apache.commons.lang.builder.ToStringBuilder;
import org.springframework.format.annotation.DateTimeFormat;

/**
 * 按日期分页查询(开始和结束时间不能为空)
 * 
 * @author: leiliang
 * @version:
 */
public class BaseDateQueryDto extends BaseQueryDto {

    /**
     * @since JDK 1.6
     */
    private static final long serialVersionUID = -6345033870893763198L;

    /** 开始时间. */
    @ApiModelProperty(value = "开始时间", required = true)
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date              startTime;

    /** 结束时间. */
    @ApiModelProperty(value = "结束时间", required = true)
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date              endTime;

    /**
     * 
     * 显式声明构造函数
     *
     */
    public BaseDateQueryDto() {
        super();
    }

    /**
     * 
     * 接收开始时间，结束时间
     *
     * @param startTime
     * @param endTime
     */
    public BaseDateQueryDto(Date startTime, Date endTime) {
        super();
        this.startTime = startTime;
        this.endTime = endTime;
    }

    public Date getStartTime() {
        return startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getEndTime() {
        return endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

}
