/**
 * Copyright (c) 2018, duiba.com.cn All Rights Reserved.
 */
package cn.com.duiba.tuia.ssp.center.api.params;

import cn.com.duiba.tuia.ssp.center.api.dto.BaseQueryDto;

/**
 * 描述: 域名管理查询条件
 *
 * @version v1.0
 * @auther guopengfei@duiba.com.cn
 * @date 2018/1/25 10:00
 */
public class DomainCheckManagerQuery extends BaseQueryDto {

    /* 域名名称 */
    private String domainName;
    /* 域名状态 0:初始化；1:正常；2:异常 */
    private Integer domainStatus;
    /* 域名类型 1:投放域名；2:活动域名；3:落地页域名 */
    private Integer domainType;
    /* 域名标签 */
    private Long domainTag;
    /* http类型 1:http;2:https */
    private String httpType;
    /* 删除状态 0：未删除，1：删除 */
    private Integer deleted = 0;

    public String getDomainName() {
        return domainName;
    }

    public void setDomainName(String domainName) {
        this.domainName = domainName;
    }

    public Integer getDomainStatus() {
        return domainStatus;
    }

    public void setDomainStatus(Integer domainStatus) {
        this.domainStatus = domainStatus;
    }

    public Integer getDomainType() {
        return domainType;
    }

    public void setDomainType(Integer domainType) {
        this.domainType = domainType;
    }

    public Long getDomainTag() {
        return domainTag;
    }

    public void setDomainTag(Long domainTag) {
        this.domainTag = domainTag;
    }

    public String getHttpType() {
        return httpType;
    }

    public void setHttpType(String httpType) {
        this.httpType = httpType;
    }

    public Integer getDeleted() {
        return deleted;
    }

    public void setDeleted(Integer deleted) {
        this.deleted = deleted;
    }
}
