package cn.com.duiba.tuia.ssp.center.api.remote;

import java.util.List;

import org.apache.ibatis.annotations.Param;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.ssp.center.api.dto.ActivityGroupDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

@AdvancedFeignClient
public interface RemoteActivityGroupService {

	DubboResult<List<ActivityGroupDto>> listAct4Group(Long groupId);
	
	//添加活动组活动
	DubboResult<Integer> insert(ActivityGroupDto dto);
	
	//更新活动有效时间
	DubboResult<Integer> updateEffectTime(ActivityGroupDto dto);
	
	//删除活动组活动
	DubboResult<Integer> deleteAct(@Param("actGroupId")Long actGroupId,
			@Param("activityId")Long activityId,
			@Param("actSource")Integer actSource);
	
	//通过活动id 查询组内的广告位ID
	DubboResult<List<Long>> listSlotIdByActId(Long activityId,Integer source);
	
}
