package cn.com.duiba.tuia.ssp.center.api.dto;

import java.io.Serializable;

import javax.validation.constraints.NotNull;

import org.apache.commons.lang3.builder.ToStringBuilder;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

@ApiModel
public class ReqActivityHourStatistics extends ReqStatHourlySort implements Serializable{

	private static final long serialVersionUID = 734328279254869766L;

	/** 媒体ID. */
    @ApiModelProperty(value = "活动ID", required = false)
    private Long   activityId;

    /** 查询日期. */
    @ApiModelProperty(value = "查询日期", required = true)
    @NotNull(message = "查询日期不能为空")
    private String curDate;

    /** The app name. */
    @ApiModelProperty(value = "活动名称(用作导出)", required = false)
    private String activityName;
    
    @ApiModelProperty(value = "活动来源(用作导出)", required = false)
    private Integer source;

	public Long getActivityId() {
		return activityId;
	}

	public void setActivityId(Long activityId) {
		this.activityId = activityId;
	}

	public String getCurDate() {
		return curDate;
	}

	public void setCurDate(String curDate) {
		this.curDate = curDate;
	}

	public String getActivityName() {
		return activityName;
	}

	public void setActivityName(String activityName) {
		this.activityName = activityName;
	}

	public Integer getSource() {
		return source;
	}

	public void setSource(Integer source) {
		this.source = source;
	}

	@Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }
}
