package cn.com.duiba.tuia.ssp.center.api.remote;


import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.ssp.center.api.dto.MaterialStatisticsDto;
import cn.com.duiba.tuia.ssp.center.api.dto.ReqMaterialActStatistics;
import cn.com.duiba.tuia.ssp.center.api.dto.ReqMaterialSlotStatistics;
import cn.com.duiba.tuia.ssp.center.api.dto.ReqMaterialStatistics;
import cn.com.duiba.tuia.ssp.center.api.dto.ReqMaterialStatisticsBase;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.List;

@AdvancedFeignClient
public interface RemoteSlotMaterialStatisticsDayService {
    DubboResult<List<MaterialStatisticsDto>> selectMaterialStaticList(ReqMaterialStatistics req);

    DubboResult<Integer> selectMaterialStaticCount(ReqMaterialStatistics req);

    DubboResult<Integer> selectMaterialDayStaticCount(ReqMaterialStatisticsBase req);

    DubboResult<List<MaterialStatisticsDto>> selectMaterialDayStaticList(ReqMaterialStatisticsBase req);

    DubboResult<Integer> selectMaterialSlotStaticCount(ReqMaterialSlotStatistics req);

    DubboResult<List<MaterialStatisticsDto>> selectMaterialSlotStaticList(ReqMaterialSlotStatistics req);

    DubboResult<Integer> selectMaterialSlotDayStaticCount(ReqMaterialSlotStatistics req);

    DubboResult<List<MaterialStatisticsDto>> selectSlotMaterialStatisList(ReqMaterialSlotStatistics req);

    DubboResult<Integer> selectSlotMaterialStatisCount(ReqMaterialSlotStatistics req);

	DubboResult<List<MaterialStatisticsDto>> listMaterialStatis(ReqMaterialStatistics reqMaterialStatistics);
	
	DubboResult<Integer> countMaterialStatis(ReqMaterialStatistics reqMaterialStatistics);
	
	DubboResult<List<MaterialStatisticsDto>> listDayMaterialStatic(ReqMaterialStatisticsBase reqMaterialStatisticsBase);
	
	DubboResult<Integer> countDayMaterialStatic(ReqMaterialStatisticsBase reqMaterialStatisticsBase);
	
	/**
	 * 
	 * selectSlotMaterialActStatis:(查询广告位素材活动维度数据). <br/>
	 *
	 * @author guyan
	 * @param req
	 * @return
	 * @since JDK 1.6
	 */
	DubboResult<List<MaterialStatisticsDto>> selectSlotMaterialActStatis(ReqMaterialActStatistics req);
	
	/**
	 * 
	 * selectSlotMaterialActStatisCount:(查询广告位素材活动维度数据数量). <br/>
	 *
	 * @author guyan
	 * @param req
	 * @return
	 * @since JDK 1.6
	 */
	DubboResult<Integer> selectSlotMaterialActStatisCount(ReqMaterialActStatistics req);
	
	/**
	 * 
	 * selectSlotMaterialActDailyStatis:(查询广告位素材活动维度每日数据). <br/>
	 *
	 * @author guyan
	 * @param req
	 * @return
	 * @since JDK 1.6
	 */
	DubboResult<List<MaterialStatisticsDto>> selectSlotMaterialActDailyStatis(ReqMaterialActStatistics req);
	
	/**
	 * 
	 * selectSlotMaterialActDailyStatisCount:(查询广告位素材活动维度每日数据数量). <br/>
	 *
	 * @author guyan
	 * @param req
	 * @return
	 * @since JDK 1.6
	 */
	DubboResult<Integer> selectSlotMaterialActDailyStatisCount(ReqMaterialActStatistics req);
}
