/**
 * Project Name:ssp-center-api
 * File Name:DeliveryType.java
 * Package Name:cn.com.duiba.tuia.ssp.center.api.constant
 * Date:2017年11月29日下午7:13:49
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 */

package cn.com.duiba.tuia.ssp.center.api.constant;

/**
 * 描述: 域名场景
 *
 * @version v1.0
 * @auther guopengfei@duiba.com.cn
 * @date 2018/1/25 09:37
 */
public enum DomainSceneType {

    WE_CHAT(1, "WE_CHAT", "微信"),

    QQ(2, "QQ", "QQ"),

    ALIPAY(3, "ALIPAY", "支付宝"),

    BROWSER_QQ(4, "BROWSER_QQ", "QQ浏览器"),

    BROWSER_360(5, "BROWSER_360", "360浏览器");

    private Integer type;

    private String code;

    private String desc;


    DomainSceneType(Integer type, String code, String desc) {
        this.type = type;
        this.code = code;
        this.desc = desc;
    }

    public Integer getType() {
        return type;
    }

    public String getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    public static DomainSceneType getByCode(String code) {
        for (DomainSceneType e : DomainSceneType.values()) {
            if (e.getCode().equals(code)) {
                return e;
            }
        }
        return WE_CHAT;
    }

}

