/**
 * Project Name:ssp-center-api
 * File Name:ReqAccountRemitDto.java
 * Package Name:cn.com.duiba.tuia.ssp.center.api.dto
 * Date:2017年7月6日下午11:01:42
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.tuia.ssp.center.api.dto;

import java.util.List;

import org.apache.commons.lang.builder.ToStringBuilder;
import org.springframework.format.annotation.DateTimeFormat;

import io.swagger.annotations.ApiModelProperty;

/**
 * ClassName:ReqAccountRemitDto <br/>
 * Date:     2017年7月6日 下午11:01:42 <br/>
 * @author   guyan
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
public class ReqAccountRemitByPage extends BaseQueryDto {

    /**序列号*/
    private static final long serialVersionUID = 936427635916750070L;

    /**确认打款时间*/
    @ApiModelProperty(value = "确认打款日期", required = true)
    @DateTimeFormat(pattern = "yyyy-MM")
    private String remitDate;
    
    /**媒体名称*/
    @ApiModelProperty(value = "媒体名称", required = false)
    private String appName;
    
    /**媒体ID*/
    @ApiModelProperty(value = "媒体ID", required = false)
    private Long appId;
    
    @ApiModelProperty(value = "媒体IDS", required = false)
    private List<Long> appIds;
    
    @ApiModelProperty(value = "提现单号", required = false)
    private Long    cashOrderNo;    
    
    
    
    public Long getCashOrderNo() {
        return cashOrderNo;
    }

    public void setCashOrderNo(Long cashOrderNo) {
        this.cashOrderNo = cashOrderNo;
    }


    public List<Long> getAppIds() {
        return appIds;
    }


    
    public void setAppIds(List<Long> appIds) {
        this.appIds = appIds;
    }


    public String getRemitDate() {
        return remitDate;
    }

    
    public void setRemitDate(String remitDate) {
        this.remitDate = remitDate;
    }

    
    public String getAppName() {
        return appName;
    }

    
    public void setAppName(String appName) {
        this.appName = appName;
    }

    
    public Long getAppId() {
        return appId;
    }

    
    public void setAppId(Long appId) {
        this.appId = appId;
    }
    
    /**
     * To string.
     *
     * @return the string
     */
    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

}

