/**
 * Project Name:ssp-center-api
 * File Name:RemoteMediaSlotDailyRecordService.java
 * Package Name:cn.com.duiba.tuia.ssp.center.api.remote
 * Date:2018年1月17日下午5:40:15
 * Copyright (c) 2018, duiba.com.cn All Rights Reserved.
 *
*/
/**
 * Project Name:ssp-center-api
 * File Name:RemoteMediaSlotDailyRecordService.java
 * Package Name:cn.com.duiba.tuia.ssp.center.api.remote
 * Date:2018年1月17日下午5:40:15
 * Copyright (c) 2018, duiba.com.cn All Rights Reserved.
 *
 */

package cn.com.duiba.tuia.ssp.center.api.remote;

import java.util.Date;
import java.util.List;
import java.util.Map;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.ssp.center.api.dto.MediaSlotDailyRecordDto;
import cn.com.duiba.tuia.ssp.center.api.dto.ReqSlotStatDailyByPage;

/**
 * ClassName:RemoteMediaSlotDailyRecordService <br/>
 * Function: 媒体广告位记录表. <br/>
 * Date:     2018年1月17日 下午5:40:15 <br/>
 * @author   guyan
 * @version  
 * @see 	 
 */
@AdvancedFeignClient
public interface RemoteMediaSlotDailyRecordService {
    
    List<MediaSlotDailyRecordDto> selectDailyRecord(ReqSlotStatDailyByPage param);

    List<MediaSlotDailyRecordDto> selectListByCurDatesAndSlotIds(List<Date> curDates, List<Long> slotIds);
    
    List<MediaSlotDailyRecordDto> selectList(List<Long> appIds);
    
    List<MediaSlotDailyRecordDto> selectListChageType(List<Long> appIds);
}

