/**
 * Project Name:media-biz
 * File Name:BaseCashBillDto.java
 * Package Name:cn.com.duiba.tuia.media.domain
 * Date:2017年5月9日下午4:10:38
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.tuia.ssp.center.api.dto;

import java.io.Serializable;

import javax.validation.constraints.NotNull;

import javax.validation.constraints.NotBlank;

import io.swagger.annotations.ApiModelProperty;

/**
 * ClassName:BaseCashBillDto <br/>
 * Function: 提现信息. <br/>
 * Date:     2017年5月9日 下午4:10:38 <br/>
 * @author   guyan
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
public class BaseCashBillDto implements Serializable  {
    
    /**序列号*/
    private static final long serialVersionUID = -3237195163611290437L;
    
    /**发票金额*/
    @ApiModelProperty(value = "发票金额", required = true)
    @NotNull(message="发票金额为空")
    private Long invoiceAmount;
    
    /**发票编号*/
    @ApiModelProperty(value = "发票编号", required = true)
    @NotBlank(message="发票编号为空")
    private String invoiceNo; 
    
    /**发票图片*/
    @ApiModelProperty(value = "发票图片", required = true)
    @NotBlank(message="发票图片为空")
    private String pictureUrl;
    
    public String getInvoiceNo() {
        return invoiceNo;
    }
    
    public void setInvoiceNo(String invoiceNo) {
        this.invoiceNo = invoiceNo;
    }

    
    public String getPictureUrl() {
        return pictureUrl;
    }

    
    public void setPictureUrl(String pictureUrl) {
        this.pictureUrl = pictureUrl;
    }

    public Long getInvoiceAmount() {
        return invoiceAmount;
    }
    
    public void setInvoiceAmount(Long invoiceAmount) {
        this.invoiceAmount = invoiceAmount;
    }
}

