/**
 * Project Name:media-manager-biz<br>
 * File Name:ReqAppSlotStatistics.java<br>
 * Package Name:cn.com.duiba.tuia.media.manager.model.req<br>
 * Date:2016年12月22日下午2:18:18<br>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.<br>
 */
package cn.com.duiba.tuia.ssp.center.api.dto;

import java.util.List;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;

import org.apache.commons.lang3.builder.ToStringBuilder;

/**
 * ClassName: ReqAppSlotStatistics <br/>
 * Function: 媒体广告位请求对象. <br/>
 * date: 2016年12月22日 下午2:18:18 <br/>
 *
 * @author xiawei
 * @version
 * @since JDK 1.6
 */
@ApiModel
public class ReqAppSlotStatistics extends ReqDateQuery {

    /**序列号*/
    private static final long serialVersionUID = 4613259596584046543L;

    /** The app id. */
    @ApiModelProperty(value = "媒体ID", required = true)
    @NotNull(message = "媒体ID不能为空")
    private Long       appId;

    /** The slot id. */
    @ApiModelProperty(value = "广告位ID", required = false)
    private Long       slotId;

    /** The slot name. */
    @ApiModelProperty(value = "广告位名称", required = false)
    private String     slotName;

    /** The slot type. */
    @ApiModelProperty(value = "广告位类型", required = false)
    private Integer    slotType;

    /** 广告位ID集合. */
    private List<Long> slotIds;

    /** The app name. */
    @ApiModelProperty(value = "媒体名称(用作导出)", required = false)
    private String     appName;

    /** The platform. */
    @ApiModelProperty(value = "媒体所属平台(用作导出)", required = false)
    private String     platform;

    /** 导出方式. */
    @ApiModelProperty(value = "导出方式", required = false)
    private Integer     exportType;//0是汇总，1是分日导出

    public Integer getExportType() {
		return exportType;
	}

	public void setExportType(Integer exportType) {
		this.exportType = exportType;
	}
    
    /**
     * Gets the app id.
     *
     * @return the app id
     */
    public Long getAppId() {
        return appId;
    }

    /**
     * Sets the app id.
     *
     * @param appId the app id
     */
    public void setAppId(Long appId) {
        this.appId = appId;
    }

    /**
     * Gets the slot id.
     *
     * @return the slot id
     */
    public Long getSlotId() {
        return slotId;
    }

    /**
     * Sets the slot id.
     *
     * @param slotId the slot id
     */
    public void setSlotId(Long slotId) {
        this.slotId = slotId;
    }

    /**
     * Gets the slot name.
     *
     * @return the slot name
     */
    public String getSlotName() {
        return slotName;
    }

    /**
     * Sets the slot name.
     *
     * @param slotName the slot name
     */
    public void setSlotName(String slotName) {
        this.slotName = slotName;
    }

    /**
     * Gets the slot type.
     *
     * @return the slot type
     */
    public Integer getSlotType() {
        return slotType;
    }

    /**
     * Sets the slot type.
     *
     * @param slotType the slot type
     */
    public void setSlotType(Integer slotType) {
        this.slotType = slotType;
    }

    /**
     * Gets the slot ids.
     *
     * @return the slot ids
     */
    public List<Long> getSlotIds() {
        return slotIds;
    }

    /**
     * Sets the slot ids.
     *
     * @param slotIds the slot ids
     */
    public void setSlotIds(List<Long> slotIds) {
        this.slotIds = slotIds;
    }

    /**
     * Gets the app name.
     *
     * @return the app name
     */
    public String getAppName() {
        return appName;
    }

    /**
     * Sets the app name.
     *
     * @param appName the app name
     */
    public void setAppName(String appName) {
        this.appName = appName;
    }

    /**
     * Gets the platform.
     *
     * @return the platform
     */
    public String getPlatform() {
        return platform;
    }

    /**
     * Sets the platform.
     *
     * @param platform the platform
     */
    public void setPlatform(String platform) {
        this.platform = platform;
    }

    /**
     * To string.
     *
     * @return the string
     */
    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

}
