/**
 * Project Name:ssp-center-api File Name:RemoteSlotSckService.java Package Name:cn.com.duiba.tuia.ssp.center.api.remote
 * Date:2017年11月3日下午2:42:16 Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 */

package cn.com.duiba.tuia.ssp.center.api.remote;

import java.util.List;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.ssp.center.api.dto.SlotSck;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * ClassName:RemoteSlotSckService <br/>
 * Function: 广告位素材库关联service<br/>
 * Date: 2017年11月3日 下午2:42:16 <br/>
 * 
 * @author Administrator
 * @version
 * @since JDK 1.6
 * @see
 */
@AdvancedFeignClient
public interface RemoteSlotSckService {

    DubboResult<Integer> insertBatch(List<SlotSck> slotScks);

    DubboResult<List<SlotSck>> selectBySlotId(Long slotId);

    /**
     * 查询所有的广告位定制素材，包含删除
     * @param slotId
     * @return
     */
    List<SlotSck> selectAllBySlotId(Long slotId);

    DubboResult<Integer> deleteBySlotId(Long slotId);


    Integer updateDeleteStatus(Long slotId, Integer status, List<Long> sckIds);

    Integer updateDownloadNum(Long slotId, Long sckId);
}
