/**
 * Project Name:media-api File Name:RspSlotDataStatisticsDto.java Package Name:cn.com.duiba.tuia.media.api.dto.rsp
 * Date:2016年10月13日下午8:20:08 Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 */

package cn.com.duiba.tuia.ssp.center.api.dto;

import java.io.Serializable;

import org.apache.commons.lang.builder.ToStringBuilder;

/**
 * ClassName:RspSlotDataStatisticsDto <br/>
 * Function: 广告数据统计Dto. <br/>
 * Date: 2016年10月13日 下午8:20:08 <br/>
 * 
 * @author guayn
 * @version
 * @since JDK 1.6
 * @see
 */
public class RspSlotDataStatisticsDto implements Serializable {

    /** 序列号 */
    private static final long serialVersionUID = -7019648321036508754L;

    /** 广告位ID. */
    private Long              slotId;

    /** 广告位名称. */
    private String            slotName;

    /** 广告位类型. */
    private Integer           slotType;

    /** 广告位规格名称 */
    private String            msName;

    /** 曝光量. */
    private Long              exposureCount;

    /** 点击率 */
    private Float             clickRate;

    /** 点击数. */
    private Long              clickCount;

    /** 预计收入. */
    private Long              consumeTotal;

    /** 每一千次的有效价格. */
    private Long              eCpm;

    /** 点击单价. */
    private Long              cpc;

    /** 广告位成功响应数量 */
    private Long              actSucResponseCount;
    
    /**广告位访问pv*/
    private Long              slotRequestPv;
    
    /**广告位访问uv*/
    private Long              slotRequestUv;

    private Integer           modifyStatus;

    /**
     * geteCpm:(这里用一句话描述这个方法的作用). <br/>
     *
     * @author ZFZ
     * @return
     * @since JDK 1.6
     */
    public Long geteCpm() {
        return eCpm;
    }

    /**
     * seteCpm:(这里用一句话描述这个方法的作用). <br/>
     *
     * @author ZFZ
     * @param eCpm
     * @since JDK 1.6
     */
    public void seteCpm(Long eCpm) {
        this.eCpm = eCpm;
    }

    /**
     * getCpc:(这里用一句话描述这个方法的作用). <br/>
     *
     * @author ZFZ
     * @return
     * @since JDK 1.6
     */
    public Long getCpc() {
        return cpc;
    }

    /**
     * setCpc:(这里用一句话描述这个方法的作用). <br/>
     *
     * @author ZFZ
     * @param cpc
     * @since JDK 1.6
     */
    public void setCpc(Long cpc) {
        this.cpc = cpc;
    }

    /**
     * getSlotId:(这里用一句话描述这个方法的作用). <br/>
     *
     * @author ZFZ
     * @return
     * @since JDK 1.6
     */
    public Long getSlotId() {
        return slotId;
    }

    /**
     * setSlotId:(这里用一句话描述这个方法的作用). <br/>
     *
     * @author ZFZ
     * @param slotId
     * @since JDK 1.6
     */
    public void setSlotId(Long slotId) {
        this.slotId = slotId;
    }

    /**
     * getSlotName:(这里用一句话描述这个方法的作用). <br/>
     *
     * @author ZFZ
     * @return
     * @since JDK 1.6
     */
    public String getSlotName() {
        return slotName;
    }

    /**
     * setSlotName:(这里用一句话描述这个方法的作用). <br/>
     *
     * @author ZFZ
     * @param slotName
     * @since JDK 1.6
     */
    public void setSlotName(String slotName) {
        this.slotName = slotName;
    }

    /**
     * getSlotType:(这里用一句话描述这个方法的作用). <br/>
     *
     * @author ZFZ
     * @return
     * @since JDK 1.6
     */
    public Integer getSlotType() {
        return slotType;
    }

    /**
     * setSlotType:(这里用一句话描述这个方法的作用). <br/>
     *
     * @author ZFZ
     * @param slotType
     * @since JDK 1.6
     */
    public void setSlotType(Integer slotType) {
        this.slotType = slotType;
    }

    /**
     * exposureCount.
     *
     * @return the exposureCount
     * @since JDK 1.6
     */
    public Long getExposureCount() {
        return exposureCount;
    }

    /**
     * exposureCount.
     *
     * @param exposureCount the exposureCount to set
     * @since JDK 1.6
     */
    public void setExposureCount(Long exposureCount) {
        this.exposureCount = exposureCount;
    }

    /**
     * clickCount.
     *
     * @return the clickCount
     * @since JDK 1.6
     */
    public Long getClickCount() {
        return clickCount;
    }

    /**
     * clickCount.
     *
     * @param clickCount the clickCount to set
     * @since JDK 1.6
     */
    public void setClickCount(Long clickCount) {
        this.clickCount = clickCount;
    }

    /**
     * getConsumeTotal:(这里用一句话描述这个方法的作用). <br/>
     *
     * @author ZFZ
     * @return
     * @since JDK 1.6
     */
    public Long getConsumeTotal() {
        return consumeTotal;
    }

    /**
     * setConsumeTotal:(这里用一句话描述这个方法的作用). <br/>
     *
     * @author ZFZ
     * @param consumeTotal
     * @since JDK 1.6
     */
    public void setConsumeTotal(Long consumeTotal) {
        this.consumeTotal = consumeTotal;
    }

    /**
     * clickRate.
     *
     * @return the clickRate
     * @since JDK 1.6
     */
    public Float getClickRate() {
        return clickRate;
    }

    /**
     * msName.
     *
     * @param msName the msName to set
     * @since JDK 1.6
     */
    public void setClickRate(Float clickRate) {
        this.clickRate = clickRate;
    }

    /**
     * msName.
     *
     * @return the msName
     * @since JDK 1.6
     */
    public String getMsName() {
        return msName;
    }

    /**
     * clickRate.
     *
     * @param clickRate the clickRate to set
     * @since JDK 1.6
     */
    public void setMsName(String msName) {
        this.msName = msName;
    }
     
    /**
     * actSucResponseCount.
     *
     * @return the actSucResponseCount
     * @since JDK 1.6
     */
    public Long getActSucResponseCount() {
        return actSucResponseCount;
    }
    
    /**
     * actSucResponseCount.
     *
     * @param actSucResponseCount the actSucResponseCount to set
     * @since JDK 1.6
     */
    public void setActSucResponseCount(Long actSucResponseCount) {
        this.actSucResponseCount = actSucResponseCount;
    }
    
    /**
     * slotRequestPv.
     *
     * @return the slotRequestPv
     * @since JDK 1.6
     */
    public Long getSlotRequestPv() {
        return slotRequestPv;
    }

    /**
     * slotRequestPv.
     *
     * @param slotRequestPv the slotRequestPv to set
     */
    public void setSlotRequestPv(Long slotRequestPv) {
        this.slotRequestPv = slotRequestPv;
    }

    /**
     * slotRequestUv.
     *
     * @return the slotRequestUv
     * @since JDK 1.6
     */
    public Long getSlotRequestUv() {
        return slotRequestUv;
    }

    /**
     * slotRequestUv.
     *
     * @param slotRequestUv the slotRequestUv to set
     */
    public void setSlotRequestUv(Long slotRequestUv) {
        this.slotRequestUv = slotRequestUv;
    }

    public Integer getModifyStatus() {
        return modifyStatus;
    }

    public void setModifyStatus(Integer modifyStatus) {
        this.modifyStatus = modifyStatus;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

}
