/**
 * Project Name:media-manager-common<br/>
 * File Name:GetEndOfDay.java<br/>
 * Package Name:cn.com.duiba.tuia.media.manager.common.utils<br/>
 * Date:2016年12月27日上午11:27:20<br/>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 */

package cn.com.duiba.tuia.ssp.center.api.tool;

import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

/**
 * ClassName:GetEndOfDay <br/>
 * Function: 获取指定日期的结束时间，如2018-07-24 23:59:59 <br/>
 *
 */
public class GetEndOfDay {
    
    private static Logger                        logger           = LoggerFactory.getLogger(GetEndOfDay.class);
    
    /** yyyy-MM */
    public static final SimpleDateFormat YEAR_MONTH     = getFormat("yyyy-MM");
    
    private GetEndOfDay(){
        
    }
    
    private static SimpleDateFormat getFormat(String format) {
        return new SimpleDateFormat(format);
    }


    /**
     * 
     * getEndTime:(获取指定日期的结束时间). <br/>
     *
     * @author ZFZ
     * @param endDate
     * @return
     * @since JDK 1.6
     */
    public static String getEndTime(String endDate) {
        return new DateTime(endDate).millisOfDay().withMaximumValue().toString("yyyy-MM-dd HH:mm:ss");
    }
    
    
    public static Date getDate(String dateStr, SimpleDateFormat format) {
        if ("".equals(dateStr) || dateStr == null) return null;
        try {
            return format.parse(dateStr);
        } catch (ParseException e) {
            logger.error("format yyyy-MM-dd HH:mm:ss error:", e);
        }
        return null;
    }
    
    
    public static String getStr(Date date, SimpleDateFormat format) {
        if (date == null) {
            return "";
        }
        return format.format(date);
    }
}
