package cn.com.duiba.tuia.ssp.center.api.dto.monthreport;

import java.io.Serializable;

/**
 * @author fangzhipeng
 * @date 2018/9/18
 */
public class ConsumeApp implements Serializable {

    private static final long serialVersionUID = -7688490356727056134L;

    /**
     * 媒体 appId
     */
    private Long appId;

    /**
     * 媒体名称
     */
    private String appName;

    /**
     * 媒体收益
     */
    private Long consumeTotal;

    public ConsumeApp() {}

    public ConsumeApp(String appName, Long consumeTotal) {
        this.appName = appName;
        this.consumeTotal = consumeTotal;
    }

    public ConsumeApp(Long appId, String appName, Long consumeTotal) {
        this.appId = appId;
        this.appName = appName;
        this.consumeTotal = consumeTotal;
    }

    public ConsumeApp merge(ConsumeApp other) {
        this.consumeTotal = other.getConsumeTotal() + this.consumeTotal;
        return this;
    }


    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public String getAppName() {
        return appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public Long getConsumeTotal() {
        return consumeTotal;
    }

    public void setConsumeTotal(Long consumeTotal) {
        this.consumeTotal = consumeTotal;
    }
}
