package cn.com.duiba.tuia.ssp.center.api.dto;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

import cn.com.duiba.tuia.ssp.center.api.constant.SplitConstant;

public class GroupRatioEngineDto implements Serializable {
	private static final long serialVersionUID = 5610417622992008053L;
	private Long groupId;
	private Integer sortIndex;
	/** 元素 = actId:actSource **/
	private List<String> actIdSources;

	private String activityName;
	private String activityUrl;

	public Long getGroupId() {
		return groupId;
	}
	public void setGroupId(Long groupId) {
		this.groupId = groupId;
	}
	public Integer getSortIndex() {
		return sortIndex;
	}
	public void setSortIndex(Integer sortIndex) {
		this.sortIndex = sortIndex;
	}
	public List<String> getActIdSources() {
		return actIdSources;
	}
	public void setActIdSources(List<String> actIdSources) {
		this.actIdSources = actIdSources;
	}
	
	public void addActIdSource(Long actId,Integer actSource){
		if(this.actIdSources == null){
			this.actIdSources = new ArrayList<>();
		}
		this.actIdSources.add(actId + SplitConstant.SPLIT_COLON + actSource);
	}

	public String getActivityName() {
		return activityName;
	}

	public void setActivityName(String activityName) {
		this.activityName = activityName;
	}

	public String getActivityUrl() {
		return activityUrl;
	}

	public void setActivityUrl(String activityUrl) {
		this.activityUrl = activityUrl;
	}
}
