package cn.com.duiba.tuia.ssp.center.api.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.List;
@ApiModel
public class MediaRewardSettleResult implements Serializable {

    private static final long serialVersionUID = 6155902865831265654L;

    public MediaRewardSettleResult(int code, List<IdAndNameDto> apps) {
        this.code = code;
        this.apps = apps;
    }

    public MediaRewardSettleResult() {
    }

    //返回码
    @ApiModelProperty(value = "返回码（小于0时异常，-1：没有结算单；-2：结算单没有全部结算）")
    private int code;


    //异常app列表
    @ApiModelProperty(value = "未审核通过app列表（当code=-2时不为空）")
    private List<IdAndNameDto> apps;

    public int getCode() {
        return code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public List<IdAndNameDto> getApps() {
        return apps;
    }

    public void setApps(List<IdAndNameDto> apps) {
        this.apps = apps;
    }


}
